/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import io.micronaut.coherence.ExtractorFactories;
import io.micronaut.coherence.FilterFactories;
import io.micronaut.coherence.annotation.ExtractorBinding;
import io.micronaut.coherence.annotation.Name;
import io.micronaut.coherence.annotation.SessionName;
import io.micronaut.coherence.annotation.View;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.InjectionPoint;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

@Factory
class NamedCacheFactories {
    private final BeanContext beanContext;
    private final FilterFactories filterFactory;
    private final ExtractorFactories extractorFactory;
    private final Map<ViewId, WeakReference<ContinuousQueryCache>> views = new ConcurrentHashMap<ViewId, WeakReference<ContinuousQueryCache>>();

    @Inject
    public NamedCacheFactories(BeanContext context, FilterFactories filters, ExtractorFactories extractors) {
        this.beanContext = context;
        this.filterFactory = filters;
        this.extractorFactory = extractors;
    }

    @Bean(preDestroy="release")
    @Prototype
    @Type(value={NamedCache.class})
    @Primary
    <K, V> NamedCache<K, V> getCache(InjectionPoint<?> injectionPoint) {
        return this.getCacheInternal(injectionPoint, false);
    }

    @Bean(preDestroy="release")
    @Prototype
    @Type(value={ContinuousQueryCache.class})
    @Secondary
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getNamedView(InjectionPoint<?> injectionPoint) {
        return (ContinuousQueryCache)this.getCacheInternal(injectionPoint, true);
    }

    @Prototype
    <K, V> AsyncNamedCache<K, V> getAsyncCache(InjectionPoint<?> injectionPoint) {
        NamedCache<K, V> cache = this.getCacheInternal(injectionPoint, false);
        return cache.async();
    }

    private <K, V> NamedCache<K, V> getCacheInternal(InjectionPoint<?> injectionPoint, boolean isCQC) {
        AnnotationMetadata metadata = injectionPoint.getAnnotationMetadata();
        String sessionName = metadata.getValue(SessionName.class, String.class).orElse("");
        String name = metadata.getValue(Name.class, String.class).orElse(this.getName(injectionPoint));
        boolean bl = isCQC = isCQC || injectionPoint.isAnnotationPresent(View.class);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Cannot determine cache/map name. No @Name qualifier and injection point is not named");
        }
        Session session = (Session)this.beanContext.createBean(Session.class, new Object[]{sessionName});
        NamedCache cache = session.getCache(name, new NamedMap.Option[0]);
        if (isCQC || metadata.hasAnnotation(View.class)) {
            boolean hasValues = metadata.booleanValue(View.class, "cacheValues").orElse(true);
            Filter<?> filter = this.filterFactory.filter(injectionPoint);
            ValueExtractor<?, ?> extractor = this.getExtractor(injectionPoint);
            ViewId id = new ViewId(name, sessionName, filter, hasValues, extractor);
            WeakReference refCQC = this.views.compute(id, (key, ref) -> {
                ContinuousQueryCache cqc;
                ContinuousQueryCache continuousQueryCache = cqc = ref == null ? null : (ContinuousQueryCache)ref.get();
                if (cqc == null || !cqc.isActive()) {
                    cqc = new ContinuousQueryCache(cache, filter, hasValues, null, extractor);
                    return new WeakReference<ContinuousQueryCache>(cqc);
                }
                return ref;
            });
            return (NamedCache)refCQC.get();
        }
        return cache;
    }

    private String getName(InjectionPoint<?> injectionPoint) {
        if (injectionPoint instanceof Named) {
            return ((Named)injectionPoint).getName();
        }
        return null;
    }

    private ValueExtractor<?, ?> getExtractor(InjectionPoint<?> injectionPoint) {
        if (injectionPoint.getAnnotationMetadata().hasStereotype(ExtractorBinding.class)) {
            return this.extractorFactory.extractor(injectionPoint);
        }
        return null;
    }

    static class ViewId {
        private final String name;
        private final String sessionName;
        private final Filter<?> filter;
        private final boolean hasValues;
        private final ValueExtractor<?, ?> extractor;

        ViewId(String name, String sessionName, Filter<?> filter, boolean hasValues, ValueExtractor<?, ?> extractor) {
            this.name = name;
            this.sessionName = sessionName;
            this.filter = filter;
            this.hasValues = hasValues;
            this.extractor = extractor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewId viewId = (ViewId)o;
            return this.hasValues == viewId.hasValues && Objects.equals(this.name, viewId.name) && Objects.equals(this.sessionName, viewId.sessionName) && Objects.equals(this.filter, viewId.filter) && Objects.equals(this.extractor, viewId.extractor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.sessionName, this.filter, this.hasValues, this.extractor);
        }
    }
}

