/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.net.SessionConfiguration;
import io.micronaut.coherence.AbstractSessionConfigurationBean;
import io.micronaut.coherence.SessionType;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import java.util.Optional;

@EachProperty(value="coherence.sessions", primary="default")
public class SessionConfigurationBean
extends AbstractSessionConfigurationBean {
    private String configUri;

    protected SessionConfigurationBean(@Parameter String name) {
        super(name);
    }

    @Override
    public Optional<SessionConfiguration> getConfiguration() {
        SessionType type = this.getType();
        if (type == SessionType.grpc) {
            return Optional.empty();
        }
        SessionConfiguration.Builder builder = SessionConfiguration.builder().named(this.getName()).withPriority(this.getPriority());
        String scopeName = this.getScopeName();
        if (scopeName != null) {
            builder = builder.withScopeName(scopeName);
        }
        if (this.configUri != null) {
            builder = builder.withConfigUri(this.configUri);
        }
        return Optional.of(builder.build());
    }

    public String getConfig() {
        return this.configUri;
    }

    public void setConfig(String configUri) {
        this.configUri = configUri;
    }
}

