/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.config;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Context
@Singleton
class CoherenceDefaultProperties {
    private static final String SERVICE_NAME_PREFIX = "coherence.service.prefix";
    private static final String LOG_DESTINATION = "coherence.log";
    private static final String LOG_LOGGER_NAME = "coherence.log.logger";
    private static final String LOG_MESSAGE_FORMAT = "coherence.log.format";

    @Inject
    CoherenceDefaultProperties(ApplicationContext context) {
        context.getEnvironment().addPropertySource((PropertySource)new CoherenceDefaultPropertySource());
    }

    private static Map<String, Object> createConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SERVICE_NAME_PREFIX, "${coherence.role}");
        map.put(LOG_DESTINATION, "slf4j");
        map.put(LOG_LOGGER_NAME, "coherence");
        map.put(LOG_MESSAGE_FORMAT, "(thread={thread}, member={member}, up={uptime}): {text}");
        return map;
    }

    static class CoherenceDefaultPropertySource
    extends MapPropertySource {
        CoherenceDefaultPropertySource() {
            super("coherence.defaults", CoherenceDefaultProperties.createConfig());
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }
}

