/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.grpc;

import com.oracle.coherence.grpc.proxy.GrpcServerConfiguration;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.micronaut.context.BeanContext;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.runtime.event.annotation.EventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class GrpcServerConfigurer {
    private static final List<GrpcServerConfiguration> CONFIGS = Collections.synchronizedList(new ArrayList());
    private final BeanContext beanContext;

    @Inject
    GrpcServerConfigurer(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EventListener
    void onSampleEvent(StartupEvent event) {
        Collection beans = this.beanContext.getBeansOfType(GrpcServerConfiguration.class);
        CONFIGS.addAll(beans);
    }

    public static class GrpcServerConfigurationBean
    implements GrpcServerConfiguration {
        public void configure(ServerBuilder<?> serverBuilder, InProcessServerBuilder inProcessServerBuilder) {
            for (GrpcServerConfiguration bean : CONFIGS) {
                bean.configure(serverBuilder, inProcessServerBuilder);
            }
        }
    }
}

