/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.messaging.binders;

import com.tangosol.net.topic.Subscriber;
import io.micronaut.coherence.messaging.binders.AnnotatedElementBinder;
import io.micronaut.coherence.messaging.binders.DefaultTopicBinder;
import io.micronaut.coherence.messaging.binders.ElementBinder;
import io.micronaut.coherence.messaging.binders.TypedElementBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class ElementArgumentBinderRegistry
implements ArgumentBinderRegistry<Subscriber.Element<?>> {
    private final Map<Class<? extends Annotation>, ElementBinder<?>> byAnnotation = new HashMap();
    private final Map<Integer, ElementBinder<?>> byType = new HashMap();

    public ElementArgumentBinderRegistry(ElementBinder<?> ... binders) {
        if (ArrayUtils.isNotEmpty((Object[])binders)) {
            for (ElementBinder<?> binder : binders) {
                if (binder instanceof AnnotatedElementBinder) {
                    AnnotatedElementBinder annotatedElementBinder = (AnnotatedElementBinder)binder;
                    this.byAnnotation.put(annotatedElementBinder.annotationType(), annotatedElementBinder);
                    continue;
                }
                if (!(binder instanceof TypedElementBinder)) continue;
                TypedElementBinder typedElementBinder = (TypedElementBinder)binder;
                this.byType.put(typedElementBinder.argumentType().typeHashCode(), typedElementBinder);
            }
        }
    }

    public <T> Optional<ArgumentBinder<T, Subscriber.Element<?>>> findArgumentBinder(Argument<T> argument, Subscriber.Element<?> source) {
        Optional annotationType = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (annotationType.isPresent()) {
            ElementBinder<?> elementBinder = this.byAnnotation.get(annotationType.get());
            return Optional.ofNullable(elementBinder);
        }
        ElementBinder<?> binder = this.byType.get(argument.typeHashCode());
        if (binder != null) {
            return Optional.of(binder);
        }
        return Optional.of(DefaultTopicBinder.instance());
    }
}

