/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.util.Extractors;
import com.tangosol.util.ValueExtractor;
import io.micronaut.coherence.ExtractorFactory;
import io.micronaut.coherence.FactoryQualifier;
import io.micronaut.coherence.annotation.ChainedExtractor;
import io.micronaut.coherence.annotation.ExtractorBinding;
import io.micronaut.coherence.annotation.PofExtractor;
import io.micronaut.coherence.annotation.PropertyExtractor;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Factory
public class ExtractorFactories {
    private final ApplicationContext ctx;

    @Inject
    ExtractorFactories(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    @Prototype
    ValueExtractor<?, ?> extractor(InjectionPoint<?> injectionPoint) {
        ArrayList list = new ArrayList();
        AnnotationMetadata metadata = injectionPoint.getAnnotationMetadata();
        List bindings = metadata.getAnnotationTypesByStereotype(ExtractorBinding.class);
        for (Class<? extends Annotation> type : bindings) {
            ExtractorFactory extractorFactory;
            Repeatable repeatable = type.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                type = repeatable.value();
            }
            if ((extractorFactory = (ExtractorFactory)this.ctx.findBean(ExtractorFactory.class, new FactoryQualifier(type)).orElse(null)) == null) {
                throw new IllegalStateException("Unsatisfied dependency - no ExtractorFactory bean found annotated with " + type);
            }
            ValueExtractor extractor = extractorFactory.create(injectionPoint.synthesize(type));
            if (extractor == null) {
                throw new IllegalStateException("Unsatisfied dependency - no extractor could be created by " + extractorFactory + " extractor factory.");
            }
            list.add(extractor);
        }
        ValueExtractor[] aExtractors = list.toArray(new ValueExtractor[0]);
        if (aExtractors.length == 0) {
            throw new IllegalStateException("Unsatisfied dependency - no ExtractorFactory bean found annotated with " + bindings);
        }
        if (aExtractors.length == 1) {
            return aExtractors[0];
        }
        return Extractors.multi((ValueExtractor[])aExtractors);
    }

    public <T, E> ValueExtractor<T, E> resolve(Set<Annotation> annotations) {
        ArrayList list = new ArrayList();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            ExtractorFactory extractorFactory = this.ctx.findBean(ExtractorFactory.class, new FactoryQualifier(type)).orElse(null);
            if (extractorFactory == null) {
                throw new IllegalStateException("Unsatisfied dependency - no ExtractorFactory bean found annotated with " + type);
            }
            ValueExtractor extractor = extractorFactory.create(annotation);
            if (extractor == null) {
                throw new IllegalStateException("Unsatisfied dependency - no extractor could be created by " + extractorFactory + " extractor factory.");
            }
            list.add(extractor);
        }
        ValueExtractor[] aExtractors = list.toArray(new ValueExtractor[0]);
        if (aExtractors.length == 0) {
            return null;
        }
        if (aExtractors.length == 1) {
            return aExtractors[0];
        }
        return Extractors.multi((ValueExtractor[])aExtractors);
    }

    @Singleton
    @PropertyExtractor(value="")
    ExtractorFactory<PropertyExtractor, Object, Object> universalExtractor() {
        return annotation -> Extractors.extract((String)annotation.value());
    }

    @Singleton
    @PropertyExtractor.Extractors(value={})
    ExtractorFactory<PropertyExtractor.Extractors, ?, ?> universalExtractors() {
        return annotation -> {
            ValueExtractor[] extractors = (ValueExtractor[])Arrays.stream(annotation.value()).map(ann -> Extractors.extract((String)ann.value())).toArray(ValueExtractor[]::new);
            return extractors.length == 1 ? extractors[0] : Extractors.multi((ValueExtractor[])extractors);
        };
    }

    @Singleton
    @ChainedExtractor(value={""})
    ExtractorFactory<ChainedExtractor, ?, ?> chainedExtractor() {
        return annotation -> Extractors.chained((String[])annotation.value());
    }

    @Singleton
    @ChainedExtractor.Extractors(value={})
    ExtractorFactory<ChainedExtractor.Extractors, ?, ?> chainedExtractors() {
        return annotation -> {
            ValueExtractor[] extractors = (ValueExtractor[])Arrays.stream(annotation.value()).map(ann -> Extractors.chained((String[])ann.value())).toArray(ValueExtractor[]::new);
            return extractors.length == 1 ? extractors[0] : Extractors.multi((ValueExtractor[])extractors);
        };
    }

    @Singleton
    @PofExtractor
    ExtractorFactory<PofExtractor, ?, ?> pofExtractor() {
        return annotation -> {
            Class<?> clazz = annotation.type().equals(Object.class) ? null : annotation.type();
            String sPath = annotation.path();
            int[] anIndex = annotation.index();
            if (sPath.length() == 0 && anIndex.length == 0) {
                throw new IllegalArgumentException("Neither 'index' nor 'path' are defined within @PofExtractor annotation. One is required.");
            }
            if (sPath.length() > 0 && anIndex.length > 0) {
                throw new IllegalArgumentException("Both 'index' and 'path' are defined within @PofExtractor annotation. Only one is allowed.");
            }
            if (sPath.length() > 0 && clazz == null) {
                throw new IllegalArgumentException("'type' must be specified within @PofExtractor annotation when property path is used.");
            }
            return sPath.length() > 0 ? Extractors.fromPof(clazz, (String)sPath) : Extractors.fromPof(clazz, (int[])anIndex);
        };
    }

    @Singleton
    @PofExtractor.Extractors(value={})
    ExtractorFactory<PofExtractor.Extractors, ?, ?> pofExtractors() {
        ExtractorFactory<PofExtractor, ?, ?> factory = this.pofExtractor();
        return annotation -> {
            ValueExtractor[] extractors = (ValueExtractor[])Arrays.stream(annotation.value()).map(factory::create).toArray(ValueExtractor[]::new);
            return extractors.length == 1 ? extractors[0] : Extractors.multi((ValueExtractor[])extractors);
        };
    }
}

