/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.transformer.ExtractorEventTransformer;
import io.micronaut.coherence.ExtractorFactories;
import io.micronaut.coherence.FactoryQualifier;
import io.micronaut.coherence.MapEventTransformerFactory;
import io.micronaut.coherence.annotation.ExtractorBinding;
import io.micronaut.coherence.annotation.MapEventTransformerBinding;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

@Factory
public class MapEventTransformerFactories {
    protected final ApplicationContext ctx;
    protected final ExtractorFactories extractorFactory;

    @Inject
    MapEventTransformerFactories(ApplicationContext ctx, ExtractorFactories extractorFactory) {
        this.ctx = ctx;
        this.extractorFactory = extractorFactory;
    }

    public <K, V, U> MapEventTransformer<K, V, U> resolve(Set<Annotation> annotations) {
        Optional<Annotation> optionalTransformer = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).findFirst();
        Optional<Annotation> optionalExtractor = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class)).findFirst();
        if (optionalTransformer.isPresent()) {
            Annotation annotation = optionalTransformer.get();
            Class<? extends Annotation> type = annotation.annotationType();
            MapEventTransformerFactory factory = this.ctx.findBean(MapEventTransformerFactory.class, new FactoryQualifier(type)).orElse(null);
            if (factory != null) {
                return factory.create(annotation);
            }
            throw new IllegalStateException("Unsatisfied dependency - no MapEventTransformerFactory bean found annotated with " + annotation);
        }
        if (optionalExtractor.isPresent()) {
            ValueExtractor extractor = this.extractorFactory.resolve(annotations);
            return new ExtractorEventTransformer(extractor);
        }
        return null;
    }

    @Prototype
    MapEventTransformer transformer(InjectionPoint<?> injectionPoint) {
        AnnotationMetadata metadata = injectionPoint.getAnnotationMetadata();
        List bindings = metadata.getAnnotationTypesByStereotype(MapEventTransformerBinding.class);
        for (Class type : bindings) {
            MapEventTransformerFactory factory = this.ctx.findBean(MapEventTransformerFactory.class, new FactoryQualifier(type)).orElse(null);
            if (factory == null) continue;
            return factory.create(injectionPoint.synthesize(type));
        }
        throw new IllegalStateException("Unsatisfied dependency - no MapEventTransformerFactory bean found for bindings " + bindings);
    }
}

