/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.event;

import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.MapEventTransformerFilter;
import io.micronaut.coherence.FilterFactories;
import io.micronaut.coherence.MapEventTransformerFactories;
import io.micronaut.coherence.annotation.CoherenceEventListener;
import io.micronaut.coherence.annotation.Created;
import io.micronaut.coherence.event.AnnotatedMapListener;
import io.micronaut.coherence.event.EventArgumentBinderRegistry;
import io.micronaut.coherence.event.EventObserverSupport;
import io.micronaut.coherence.event.ExecutableMethodEventObserver;
import io.micronaut.coherence.event.ExecutableMethodMapListener;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Context
public class CoherenceEventListenerProcessor
implements ExecutableMethodProcessor<CoherenceEventListener> {
    private final FilterFactories filterProducer;
    private final MapEventTransformerFactories transformerProducer;
    private final Map<String, Map<String, Set<AnnotatedMapListener<?, ?>>>> mapListeners = new HashMap();
    private final ApplicationContext ctx;
    private final EventArgumentBinderRegistry<?> binderRegistry;
    private final List<NamedEventInterceptor<?>> interceptors = new SafeLinkedList();

    @Inject
    public CoherenceEventListenerProcessor(ApplicationContext beanContext, FilterFactories filterFactories, MapEventTransformerFactories transformerFactory) {
        this.filterProducer = filterFactories;
        this.transformerProducer = transformerFactory;
        this.ctx = beanContext;
        this.binderRegistry = new EventArgumentBinderRegistry();
    }

    public List<NamedEventInterceptor<?>> getInterceptors() {
        return this.interceptors;
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        Class type;
        Argument[] arguments = method.getArguments();
        Class clazz = type = arguments.length == 1 ? arguments[0].getType() : null;
        if (type != null && (Event.class.isAssignableFrom(type) || MapEvent.class.isAssignableFrom(type))) {
            Class clsBeanType = beanDefinition.getBeanType();
            Supplier<Object> bean = () -> this.ctx.getBean(clsBeanType);
            if (Event.class.isAssignableFrom(type)) {
                ExecutableMethodEventObserver observer = new ExecutableMethodEventObserver(bean, method, this.binderRegistry);
                EventObserverSupport.EventHandler handler = EventObserverSupport.createObserver(type, observer);
                NamedEventInterceptor interceptor = new NamedEventInterceptor(observer.getId(), handler);
                this.interceptors.add(interceptor);
            } else {
                ExecutableMethodMapListener listener = new ExecutableMethodMapListener(bean, (ExecutableMethod<Object, ?>)method, this.binderRegistry);
                AnnotatedMapListener mapListener = new AnnotatedMapListener(listener, listener.getObservedQualifiers());
                this.addMapListener(mapListener);
            }
        } else {
            throw new IllegalArgumentException("The @CoherenceEventListener annotated method " + method.getTargetMethod() + " must have a single Coherence Event or MapEvent argument.");
        }
    }

    @CoherenceEventListener
    void registerMapListeners(@Created CacheLifecycleEvent event) {
        String cacheName = event.getCacheName();
        String eventScope = event.getScopeName();
        String eventSession = event.getSessionName();
        String eventService = event.getServiceName();
        Set<AnnotatedMapListener<?, ?>> setListeners = this.getMapListeners(this.removeScope(eventService), cacheName);
        Session session = (Session)Coherence.findSession((String)eventSession).orElseThrow(() -> new IllegalStateException("Cannot find a Session with name " + eventSession));
        NamedCache cache = session.getCache(cacheName, new NamedMap.Option[0]);
        for (AnnotatedMapListener<?, ?> listener : setListeners) {
            MapEventTransformer transformer;
            boolean fSessionOK;
            String sScope;
            if (listener.hasFilterAnnotation()) {
                listener.resolveFilter(this.filterProducer);
            }
            if (listener.hasTransformerAnnotation()) {
                listener.resolveTransformer(this.transformerProducer);
            }
            boolean fScopeOK = (sScope = listener.getScopeName()) == null || sScope.equals(eventScope);
            String sSession = listener.getSessionName();
            boolean bl = fSessionOK = sSession == null || sSession.equals(eventSession);
            if (!fScopeOK || !fSessionOK) continue;
            MapEventFilter filter = listener.getFilter();
            if (filter != null && !(filter instanceof MapEventFilter)) {
                filter = new MapEventFilter(7, filter);
            }
            if ((transformer = listener.getTransformer()) != null) {
                filter = new MapEventTransformerFilter((Filter)filter, transformer);
            }
            try {
                boolean fLite = listener.isLite();
                if (listener.isSynchronous()) {
                    cache.addMapListener(listener.synchronous(), (Filter)filter, fLite);
                    continue;
                }
                cache.addMapListener(listener, (Filter)filter, fLite);
            }
            catch (Exception e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        }
    }

    private String removeScope(String sServiceName) {
        if (sServiceName == null) {
            return "";
        }
        int nIndex = sServiceName.indexOf(58);
        return nIndex > -1 ? sServiceName.substring(nIndex + 1) : sServiceName;
    }

    public void addMapListener(AnnotatedMapListener<?, ?> listener) {
        String svc = listener.getServiceName();
        String cache = listener.getCacheName();
        Map mapByCache = this.mapListeners.computeIfAbsent(svc, s -> new HashMap());
        Set setListeners = mapByCache.computeIfAbsent(cache, c -> new HashSet());
        setListeners.add(listener);
    }

    public Set<AnnotatedMapListener<?, ?>> getMapListeners(String serviceName, String cacheName) {
        HashSet setResults = new HashSet();
        this.collectMapListeners(setResults, "*", "*");
        this.collectMapListeners(setResults, "*", cacheName);
        this.collectMapListeners(setResults, serviceName, "*");
        this.collectMapListeners(setResults, serviceName, cacheName);
        return setResults;
    }

    public Collection<AnnotatedMapListener<?, ?>> getNonWildcardMapListeners() {
        return this.mapListeners.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).filter(listener -> listener.getSessionName() != null).filter(listener -> !listener.isWildCardCacheName()).sorted().collect(Collectors.toList());
    }

    private void collectMapListeners(HashSet<AnnotatedMapListener<?, ?>> setResults, String serviceName, String cacheName) {
        Map<String, Set<AnnotatedMapListener<?, ?>>> mapByCache = this.mapListeners.get(serviceName);
        if (mapByCache != null) {
            setResults.addAll(mapByCache.getOrDefault(cacheName, Collections.emptySet()));
        }
    }
}

