/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.event;

import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.events.CoherenceLifecycleEvent;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.SessionLifecycleEvent;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.federation.FederatedChangeEvent;
import com.tangosol.net.events.federation.FederatedConnectionEvent;
import com.tangosol.net.events.federation.FederatedPartitionEvent;
import com.tangosol.net.events.internal.CoherenceEventDispatcher;
import com.tangosol.net.events.internal.ConfigurableCacheFactoryDispatcher;
import com.tangosol.net.events.internal.SessionEventDispatcher;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEventDispatcher;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.events.partition.cache.EntryProcessorEvent;
import com.tangosol.util.InvocableMap;
import io.micronaut.coherence.annotation.Activated;
import io.micronaut.coherence.annotation.Activating;
import io.micronaut.coherence.annotation.Arrived;
import io.micronaut.coherence.annotation.Assigned;
import io.micronaut.coherence.annotation.Backlog;
import io.micronaut.coherence.annotation.CacheName;
import io.micronaut.coherence.annotation.Committed;
import io.micronaut.coherence.annotation.Committing;
import io.micronaut.coherence.annotation.CommittingLocal;
import io.micronaut.coherence.annotation.CommittingRemote;
import io.micronaut.coherence.annotation.Connecting;
import io.micronaut.coherence.annotation.Created;
import io.micronaut.coherence.annotation.Departed;
import io.micronaut.coherence.annotation.Departing;
import io.micronaut.coherence.annotation.Destroyed;
import io.micronaut.coherence.annotation.Disconnected;
import io.micronaut.coherence.annotation.Disposing;
import io.micronaut.coherence.annotation.Error;
import io.micronaut.coherence.annotation.Executed;
import io.micronaut.coherence.annotation.Executing;
import io.micronaut.coherence.annotation.Inserted;
import io.micronaut.coherence.annotation.Inserting;
import io.micronaut.coherence.annotation.Lost;
import io.micronaut.coherence.annotation.MapName;
import io.micronaut.coherence.annotation.Name;
import io.micronaut.coherence.annotation.ParticipantName;
import io.micronaut.coherence.annotation.Processor;
import io.micronaut.coherence.annotation.Recovered;
import io.micronaut.coherence.annotation.Removed;
import io.micronaut.coherence.annotation.Removing;
import io.micronaut.coherence.annotation.Replicating;
import io.micronaut.coherence.annotation.Rollback;
import io.micronaut.coherence.annotation.ScopeName;
import io.micronaut.coherence.annotation.ServiceName;
import io.micronaut.coherence.annotation.SessionName;
import io.micronaut.coherence.annotation.Started;
import io.micronaut.coherence.annotation.Starting;
import io.micronaut.coherence.annotation.Stopped;
import io.micronaut.coherence.annotation.Stopping;
import io.micronaut.coherence.annotation.Synced;
import io.micronaut.coherence.annotation.Syncing;
import io.micronaut.coherence.annotation.Truncated;
import io.micronaut.coherence.annotation.Updated;
import io.micronaut.coherence.annotation.Updating;
import io.micronaut.coherence.event.ExecutableMethodEventObserver;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class EventObserverSupport {
    public static <E extends Event<T>, T extends Enum<T>> EventHandler<E, T> createObserver(Class<E> type, ExecutableMethodEventObserver<E, ?, ?> observer) {
        if (CacheLifecycleEvent.class.equals(type)) {
            return new CacheLifecycleEventHandler(observer);
        }
        if (CoherenceLifecycleEvent.class.equals(type)) {
            return new CoherenceLifecycleEventHandler(observer);
        }
        if (EntryEvent.class.equals(type)) {
            return new EntryEventHandler(observer);
        }
        if (EntryProcessorEvent.class.equals(type)) {
            return new EntryProcessorEventHandler(observer);
        }
        if (LifecycleEvent.class.equals(type)) {
            return new LifecycleEventHandler(observer);
        }
        if (SessionLifecycleEvent.class.equals(type)) {
            return new SessionLifecycleEventHandler(observer);
        }
        if (TransactionEvent.class.equals(type)) {
            return new TransactionEventHandler(observer);
        }
        if (TransferEvent.class.equals(type)) {
            return new TransferEventHandler(observer);
        }
        if (UnsolicitedCommitEvent.class.equals(type)) {
            return new UnsolicitedCommitEventHandler(observer);
        }
        if (FederatedChangeEvent.class.equals(type)) {
            return new FederatedChangeEventHandler(observer);
        }
        if (FederatedConnectionEvent.class.equals(type)) {
            return new FederatedConnectionEventHandler(observer);
        }
        if (FederatedPartitionEvent.class.equals(type)) {
            return new FederatedPartitionEventHandler(observer);
        }
        throw new IllegalArgumentException("Unsupported event type: " + type);
    }

    static class FederatedPartitionEventHandler
    extends FederationEventHandler<FederatedPartitionEvent, FederatedPartitionEvent.Type> {
        FederatedPartitionEventHandler(ExecutableMethodEventObserver<FederatedPartitionEvent, ?, ?> observer) {
            super(observer, FederatedPartitionEvent.Type.class, FederatedPartitionEvent::getParticipant);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Syncing) {
                    this.addType(FederatedPartitionEvent.Type.SYNCING);
                    continue;
                }
                if (!(a instanceof Synced)) continue;
                this.addType(FederatedPartitionEvent.Type.SYNCED);
            }
        }
    }

    static class FederatedChangeEventHandler
    extends FederationEventHandler<FederatedChangeEvent, FederatedChangeEvent.Type> {
        FederatedChangeEventHandler(ExecutableMethodEventObserver<FederatedChangeEvent, ?, ?> observer) {
            super(observer, FederatedChangeEvent.Type.class, FederatedChangeEvent::getParticipant);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof CommittingLocal) {
                    this.addType(FederatedChangeEvent.Type.COMMITTING_LOCAL);
                    continue;
                }
                if (a instanceof CommittingRemote) {
                    this.addType(FederatedChangeEvent.Type.COMMITTING_REMOTE);
                    continue;
                }
                if (!(a instanceof Replicating)) continue;
                this.addType(FederatedChangeEvent.Type.REPLICATING);
            }
        }
    }

    static class FederatedConnectionEventHandler
    extends FederationEventHandler<FederatedConnectionEvent, FederatedConnectionEvent.Type> {
        FederatedConnectionEventHandler(ExecutableMethodEventObserver<FederatedConnectionEvent, ?, ?> observer) {
            super(observer, FederatedConnectionEvent.Type.class, FederatedConnectionEvent::getParticipantName);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Connecting) {
                    this.addType(FederatedConnectionEvent.Type.CONNECTING);
                    continue;
                }
                if (a instanceof Disconnected) {
                    this.addType(FederatedConnectionEvent.Type.DISCONNECTED);
                    continue;
                }
                if (a instanceof Backlog) {
                    Backlog backlog = (Backlog)a;
                    if (backlog.value() == Backlog.Type.EXCESSIVE) {
                        this.addType(FederatedConnectionEvent.Type.BACKLOG_EXCESSIVE);
                        continue;
                    }
                    this.addType(FederatedConnectionEvent.Type.BACKLOG_NORMAL);
                    continue;
                }
                if (!(a instanceof Error)) continue;
                this.addType(FederatedConnectionEvent.Type.ERROR);
            }
        }
    }

    static abstract class FederationEventHandler<E extends Event<T>, T extends Enum<T>>
    extends ServiceEventHandler<E, T> {
        protected final String participantName;
        protected final Function<E, String> participantNameFunction;

        FederationEventHandler(ExecutableMethodEventObserver<E, ?, ?> observer, Class<T> type, Function<E, String> participantNameFunction) {
            super(observer, type);
            this.participantNameFunction = participantNameFunction;
            String participantName = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof ParticipantName)) continue;
                participantName = ((ParticipantName)a).value();
            }
            this.participantName = participantName;
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String sScopeName) {
            Set setSupported = dispatcher.getSupportedTypes();
            boolean fMatch = this.eventTypes().stream().anyMatch(setSupported::contains);
            return fMatch && super.isApplicable(dispatcher, sScopeName);
        }

        @Override
        protected boolean shouldFire(E event) {
            return this.participantName == null || this.participantName.equals(this.participantNameFunction.apply(event));
        }
    }

    public static class UnsolicitedCommitEventHandler
    extends ServiceEventHandler<UnsolicitedCommitEvent, UnsolicitedCommitEvent.Type> {
        public UnsolicitedCommitEventHandler(ExecutableMethodEventObserver<UnsolicitedCommitEvent, ?, ?> observer) {
            super(observer, UnsolicitedCommitEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof Committed)) continue;
                this.addType(UnsolicitedCommitEvent.Type.COMMITTED);
            }
        }
    }

    static class TransferEventHandler
    extends ServiceEventHandler<TransferEvent, TransferEvent.Type> {
        TransferEventHandler(ExecutableMethodEventObserver<TransferEvent, ?, ?> observer) {
            super(observer, TransferEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Assigned) {
                    this.addType(TransferEvent.Type.ASSIGNED);
                    continue;
                }
                if (a instanceof Arrived) {
                    this.addType(TransferEvent.Type.ARRIVED);
                    continue;
                }
                if (a instanceof Departing) {
                    this.addType(TransferEvent.Type.DEPARTING);
                    continue;
                }
                if (a instanceof Departed) {
                    this.addType(TransferEvent.Type.DEPARTED);
                    continue;
                }
                if (a instanceof Lost) {
                    this.addType(TransferEvent.Type.LOST);
                    continue;
                }
                if (a instanceof Recovered) {
                    this.addType(TransferEvent.Type.RECOVERED);
                    continue;
                }
                if (!(a instanceof Rollback)) continue;
                this.addType(TransferEvent.Type.ROLLBACK);
            }
        }
    }

    static class TransactionEventHandler
    extends ServiceEventHandler<TransactionEvent, TransactionEvent.Type> {
        TransactionEventHandler(ExecutableMethodEventObserver<TransactionEvent, ?, ?> observer) {
            super(observer, TransactionEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Committing) {
                    this.addType(TransactionEvent.Type.COMMITTING);
                    continue;
                }
                if (!(a instanceof Committed)) continue;
                this.addType(TransactionEvent.Type.COMMITTED);
            }
        }
    }

    static abstract class ServiceEventHandler<E extends Event<T>, T extends Enum<T>>
    extends EventHandler<E, T> {
        protected final String serviceName;

        ServiceEventHandler(ExecutableMethodEventObserver<E, ?, ?> observer, Class<T> classType) {
            super(observer, classType);
            String service = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof ServiceName)) continue;
                service = ((ServiceName)a).value();
            }
            this.serviceName = service;
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String scopeName) {
            PartitionedServiceDispatcher psd;
            ConfigurableCacheFactory ccf;
            if (dispatcher instanceof PartitionedServiceDispatcher && ((ccf = this.getConfigurableCacheFactory((psd = (PartitionedServiceDispatcher)dispatcher).getService())) == null || scopeName == null || scopeName.equals(ccf.getScopeName()))) {
                return this.serviceName == null || this.serviceName.equals(this.removeScope(psd.getServiceName()));
            }
            return false;
        }

        ConfigurableCacheFactory getConfigurableCacheFactory(PartitionedService service) {
            if (service instanceof CacheService) {
                CacheService pc = (CacheService)service;
                return pc.getBackingMapManager().getCacheFactory();
            }
            return null;
        }
    }

    static class EntryProcessorEventHandler
    extends CacheEventHandler<EntryProcessorEvent, EntryProcessorEvent.Type> {
        private final Class<?> m_classProcessor;

        EntryProcessorEventHandler(ExecutableMethodEventObserver<EntryProcessorEvent, ?, ?> observer) {
            super(observer, EntryProcessorEvent.Type.class);
            Class<? extends InvocableMap.EntryProcessor> classProcessor = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Processor) {
                    classProcessor = ((Processor)a).value();
                    continue;
                }
                if (a instanceof Executing) {
                    this.addType(EntryProcessorEvent.Type.EXECUTING);
                    continue;
                }
                if (!(a instanceof Executed)) continue;
                this.addType(EntryProcessorEvent.Type.EXECUTED);
            }
            this.m_classProcessor = classProcessor;
        }

        @Override
        boolean shouldFire(EntryProcessorEvent event) {
            return this.m_classProcessor == null || this.m_classProcessor.equals(event.getProcessor().getClass());
        }
    }

    static class EntryEventHandler<K, V>
    extends CacheEventHandler<EntryEvent<K, V>, EntryEvent.Type> {
        EntryEventHandler(ExecutableMethodEventObserver<EntryEvent<K, V>, ?, ?> observer) {
            super(observer, EntryEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Inserting) {
                    this.addType(EntryEvent.Type.INSERTING);
                    continue;
                }
                if (a instanceof Inserted) {
                    this.addType(EntryEvent.Type.INSERTED);
                    continue;
                }
                if (a instanceof Updating) {
                    this.addType(EntryEvent.Type.UPDATING);
                    continue;
                }
                if (a instanceof Updated) {
                    this.addType(EntryEvent.Type.UPDATED);
                    continue;
                }
                if (a instanceof Removing) {
                    this.addType(EntryEvent.Type.REMOVING);
                    continue;
                }
                if (!(a instanceof Removed)) continue;
                this.addType(EntryEvent.Type.REMOVED);
            }
        }
    }

    static class CacheLifecycleEventHandler
    extends CacheEventHandler<CacheLifecycleEvent, CacheLifecycleEvent.Type> {
        CacheLifecycleEventHandler(ExecutableMethodEventObserver<CacheLifecycleEvent, ?, ?> observer) {
            super(observer, CacheLifecycleEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Created) {
                    this.addType(CacheLifecycleEvent.Type.CREATED);
                    continue;
                }
                if (a instanceof Destroyed) {
                    this.addType(CacheLifecycleEvent.Type.DESTROYED);
                    continue;
                }
                if (!(a instanceof Truncated)) continue;
                this.addType(CacheLifecycleEvent.Type.TRUNCATED);
            }
        }
    }

    static abstract class CacheEventHandler<E extends Event<T>, T extends Enum<T>>
    extends EventHandler<E, T> {
        protected final String cacheName;
        protected final String serviceName;
        protected final String sessionName;

        CacheEventHandler(ExecutableMethodEventObserver<E, ?, ?> observer, Class<T> type) {
            super(observer, type);
            String cache = null;
            String service = null;
            String session = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof CacheName) {
                    cache = ((CacheName)a).value();
                    continue;
                }
                if (a instanceof MapName) {
                    cache = ((MapName)a).value();
                    continue;
                }
                if (a instanceof ServiceName) {
                    service = ((ServiceName)a).value();
                    continue;
                }
                if (!(a instanceof SessionName)) continue;
                session = ((SessionName)a).value();
            }
            this.cacheName = cache;
            this.serviceName = service;
            this.sessionName = session;
        }

        @Override
        boolean isApplicable(EventDispatcher dispatcher, String scopeName) {
            if (dispatcher instanceof CacheLifecycleEventDispatcher) {
                CacheLifecycleEventDispatcher cacheDispatcher = (CacheLifecycleEventDispatcher)dispatcher;
                if (scopeName == null || scopeName.equals(cacheDispatcher.getScopeName())) {
                    return !(this.cacheName != null && !this.cacheName.equals(cacheDispatcher.getCacheName()) || this.serviceName != null && !this.serviceName.equals(this.removeScope(cacheDispatcher.getServiceName())));
                }
            }
            return false;
        }
    }

    static class LifecycleEventHandler
    extends EventHandler<LifecycleEvent, LifecycleEvent.Type> {
        LifecycleEventHandler(ExecutableMethodEventObserver<LifecycleEvent, ?, ?> observer) {
            super(observer, LifecycleEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Activating) {
                    this.addType(LifecycleEvent.Type.ACTIVATING);
                    continue;
                }
                if (a instanceof Activated) {
                    this.addType(LifecycleEvent.Type.ACTIVATED);
                    continue;
                }
                if (!(a instanceof Disposing)) continue;
                this.addType(LifecycleEvent.Type.DISPOSING);
            }
        }

        @Override
        boolean isApplicable(EventDispatcher dispatcher, String scopeName) {
            return dispatcher instanceof ConfigurableCacheFactoryDispatcher;
        }

        @Override
        String getEventScope(LifecycleEvent event) {
            return event.getConfigurableCacheFactory().getScopeName();
        }
    }

    static class SessionLifecycleEventHandler
    extends EventHandler<SessionLifecycleEvent, SessionLifecycleEvent.Type> {
        private String name;

        SessionLifecycleEventHandler(ExecutableMethodEventObserver<SessionLifecycleEvent, ?, ?> observer) {
            super(observer, SessionLifecycleEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Starting) {
                    this.addType(SessionLifecycleEvent.Type.STARTING);
                    continue;
                }
                if (a instanceof Started) {
                    this.addType(SessionLifecycleEvent.Type.STARTED);
                    continue;
                }
                if (a instanceof Stopping) {
                    this.addType(SessionLifecycleEvent.Type.STOPPING);
                    continue;
                }
                if (a instanceof Stopped) {
                    this.addType(SessionLifecycleEvent.Type.STOPPED);
                    continue;
                }
                if (a instanceof Name) {
                    this.name = ((Name)a).value();
                    continue;
                }
                if (!(a instanceof SessionName)) continue;
                this.name = ((SessionName)a).value();
            }
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String scopeName) {
            return dispatcher instanceof SessionEventDispatcher && (this.name == null || ((SessionEventDispatcher)dispatcher).getName().equals(this.name));
        }
    }

    static class CoherenceLifecycleEventHandler
    extends EventHandler<CoherenceLifecycleEvent, CoherenceLifecycleEvent.Type> {
        private String name;

        CoherenceLifecycleEventHandler(ExecutableMethodEventObserver<CoherenceLifecycleEvent, ?, ?> observer) {
            super(observer, CoherenceLifecycleEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Starting) {
                    this.addType(CoherenceLifecycleEvent.Type.STARTING);
                    continue;
                }
                if (a instanceof Started) {
                    this.addType(CoherenceLifecycleEvent.Type.STARTED);
                    continue;
                }
                if (a instanceof Stopping) {
                    this.addType(CoherenceLifecycleEvent.Type.STOPPING);
                    continue;
                }
                if (a instanceof Stopped) {
                    this.addType(CoherenceLifecycleEvent.Type.STOPPED);
                    continue;
                }
                if (!(a instanceof Name)) continue;
                this.name = ((Name)a).value();
            }
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String scopeName) {
            return dispatcher instanceof CoherenceEventDispatcher && (this.name == null || ((CoherenceEventDispatcher)dispatcher).getName().equals(this.name));
        }
    }

    static abstract class EventHandler<E extends Event<T>, T extends Enum<T>>
    implements EventDispatcherAwareInterceptor<E> {
        protected final ExecutableMethodEventObserver<E, ?, ?> observer;
        protected final EnumSet<T> eventTypes;
        private final String scopeName;

        EventHandler(ExecutableMethodEventObserver<E, ?, ?> observer, Class<T> classEventType) {
            this.observer = observer;
            this.eventTypes = EnumSet.noneOf(classEventType);
            String sScope = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof ScopeName)) continue;
                sScope = ((ScopeName)a).value();
            }
            this.scopeName = sScope;
        }

        public void introduceEventDispatcher(String identifier, EventDispatcher dispatcher) {
            if (this.isApplicable(dispatcher, this.scopeName)) {
                dispatcher.addEventInterceptor(this.getId(), (EventInterceptor)this, this.eventTypes(), false);
            }
        }

        public void onEvent(E event) {
            if (this.shouldFire(event)) {
                String observerScope = this.scopeName;
                String eventScope = this.getEventScope(event);
                if (observerScope == null || eventScope == null || observerScope.equals(eventScope)) {
                    if (this.observer.isAsync()) {
                        CompletableFuture.supplyAsync(() -> {
                            this.observer.notify((Event)event);
                            return event;
                        });
                    } else {
                        this.observer.notify(event);
                    }
                }
            }
        }

        String getId() {
            return this.observer.getId();
        }

        abstract boolean isApplicable(EventDispatcher var1, String var2);

        boolean shouldFire(E event) {
            return true;
        }

        String getEventScope(E event) {
            return null;
        }

        void addType(T type) {
            this.eventTypes.add(type);
        }

        protected EnumSet<T> eventTypes() {
            return this.eventTypes.isEmpty() ? EnumSet.complementOf(this.eventTypes) : this.eventTypes;
        }

        public String getScopeName() {
            return this.scopeName;
        }

        protected String removeScope(String serviceName) {
            int nIndex = serviceName.indexOf(58);
            return nIndex > -1 ? serviceName.substring(nIndex + 1) : serviceName;
        }
    }
}

