/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.grpc;

import com.oracle.coherence.grpc.proxy.GrpcServerBuilderProvider;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.micronaut.context.BeanContext;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.runtime.event.annotation.EventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class GrpcServerBuilder {
    private static final List<ServerBuilder> BUILDERS = Collections.synchronizedList(new ArrayList());
    private final BeanContext beanContext;

    @Inject
    GrpcServerBuilder(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EventListener
    void onSampleEvent(StartupEvent event) {
        Collection beans = this.beanContext.getBeansOfType(ServerBuilder.class);
        BUILDERS.addAll(beans);
    }

    public static class GrpcServerBuilderProviderBean
    implements GrpcServerBuilderProvider {
        public ServerBuilder<?> getServerBuilder(int port) {
            if (BUILDERS.isEmpty()) {
                return INSTANCE.getServerBuilder(port);
            }
            return (ServerBuilder)BUILDERS.get(0);
        }

        public InProcessServerBuilder getInProcessServerBuilder(String name) {
            return INSTANCE.getInProcessServerBuilder(name);
        }
    }
}

