/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.namespace;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Objects;

class BeanBuilder
implements ParameterizedBuilder<Object>,
ParameterizedBuilder.ReflectionSupport {
    private final ApplicationContext context;
    private final Expression<String> beanNameExpression;

    BeanBuilder(ApplicationContext context, String beanNameExpression) {
        this.context = Objects.requireNonNull(context);
        this.beanNameExpression = new LiteralExpression((Object)beanNameExpression);
    }

    public Object realize(ParameterResolver resolver, ClassLoader loader, ParameterList parameterList) {
        String beanName = (String)this.beanNameExpression.evaluate(resolver);
        return this.context.findBean(Object.class, Qualifiers.byName((String)beanName)).orElseThrow(() -> new ConfigurationException(String.format("Cannot resolve bean '%s', ", beanName), "Ensure that a bean with that name exists and can be discovered"));
    }

    public boolean realizes(Class<?> aClass, ParameterResolver resolver, ClassLoader loader) {
        String beanName = (String)this.beanNameExpression.evaluate(resolver);
        return this.context.findBean(aClass, Qualifiers.byName((String)beanName)).isPresent();
    }
}

