/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.QueryHelper;
import io.micronaut.coherence.FactoryQualifier;
import io.micronaut.coherence.FilterFactory;
import io.micronaut.coherence.annotation.AlwaysFilter;
import io.micronaut.coherence.annotation.FilterBinding;
import io.micronaut.coherence.annotation.WhereFilter;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Factory
public class FilterFactories {
    private final ApplicationContext ctx;

    @Inject
    FilterFactories(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    @Singleton
    @AlwaysFilter
    FilterFactory<AlwaysFilter, ?> alwaysFactory() {
        return annotation -> Filters.always();
    }

    @Singleton
    @WhereFilter(value="")
    FilterFactory<WhereFilter, ?> whereFactory() {
        return annotation -> {
            String sWhere = annotation.value();
            return sWhere.trim().isEmpty() ? Filters.always() : QueryHelper.createFilter((String)annotation.value());
        };
    }

    @Prototype
    Filter<?> filter(InjectionPoint<?> injectionPoint) {
        AnnotationMetadata metadata = injectionPoint.getAnnotationMetadata();
        List bindings = metadata.getAnnotationTypesByStereotype(FilterBinding.class);
        for (Class<? extends Annotation> type : bindings) {
            FilterFactory filterFactory;
            Repeatable repeatable = type.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                type = repeatable.value();
            }
            if ((filterFactory = (FilterFactory)this.ctx.findBean(FilterFactory.class, new FactoryQualifier(type)).orElse(null)) == null) continue;
            return filterFactory.create(injectionPoint.synthesize(type));
        }
        return Filters.always();
    }

    public <T> Filter<T> resolve(Set<Annotation> annotations) {
        ArrayList list = new ArrayList();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (!type.isAnnotationPresent(FilterBinding.class)) continue;
            FilterFactory factory = this.ctx.findBean(FilterFactory.class, new FactoryQualifier(type)).orElse(null);
            if (factory != null) {
                Filter filter = factory.create(annotation);
                if (filter == null) continue;
                list.add(filter);
                continue;
            }
            throw new IllegalStateException("Unsatisfied dependency - no FilterFactory bean found annotated with " + annotation);
        }
        Filter[] aFilters = list.toArray(new Filter[0]);
        if (aFilters.length == 0) {
            return Filters.always();
        }
        if (aFilters.length == 1) {
            return aFilters[0];
        }
        return Filters.all((Filter[])aFilters);
    }
}

