/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.net.Session;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import io.micronaut.coherence.ExtractorFactories;
import io.micronaut.coherence.FilterFactories;
import io.micronaut.coherence.annotation.ExtractorBinding;
import io.micronaut.coherence.annotation.FilterBinding;
import io.micronaut.coherence.annotation.Name;
import io.micronaut.coherence.annotation.SessionName;
import io.micronaut.coherence.annotation.SubscriberGroup;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.InjectionPoint;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
class NamedTopicFactories {
    private static final Logger LOG = LoggerFactory.getLogger(NamedTopicFactories.class);
    private final BeanContext beanContext;
    private final FilterFactories filterFactory;
    private final ExtractorFactories extractorFactory;

    NamedTopicFactories(BeanContext beanContext, FilterFactories filterFactory, ExtractorFactories extractorFactory) {
        this.beanContext = beanContext;
        this.filterFactory = filterFactory;
        this.extractorFactory = extractorFactory;
    }

    @Bean(preDestroy="release")
    @Prototype
    @Type(value={NamedTopic.class})
    <V> NamedTopic<V> getTopic(InjectionPoint<?> injectionPoint) {
        return this.getTopicInternal(injectionPoint);
    }

    @Bean(preDestroy="close")
    @Prototype
    @Type(value={Publisher.class})
    <V> Publisher<V> getPublisher(InjectionPoint<?> injectionPoint) {
        NamedTopic<V> topic = this.getTopicInternal(injectionPoint);
        return topic.createPublisher();
    }

    @Bean(preDestroy="close")
    @Prototype
    @Type(value={Subscriber.class})
    <V> Subscriber<V> getSubscriber(InjectionPoint<?> injectionPoint) {
        AnnotationMetadata metadata = injectionPoint.getAnnotationMetadata();
        ArrayList<Object> options = new ArrayList<Object>();
        String groupName = metadata.getValue(SubscriberGroup.class, String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            options.add(Subscriber.Name.of((String)groupName));
        }
        if (metadata.hasStereotype(FilterBinding.class)) {
            Filter<?> filter = this.filterFactory.filter(injectionPoint);
            options.add(Subscriber.Filtered.by(filter));
        }
        if (metadata.hasStereotype(ExtractorBinding.class)) {
            ValueExtractor<?, ?> extractor = this.extractorFactory.extractor(injectionPoint);
            options.add(Subscriber.Convert.using(extractor));
        }
        NamedTopic<V> topic = this.getTopicInternal(injectionPoint);
        return options.isEmpty() ? topic.createSubscriber() : topic.createSubscriber(options.toArray(new Subscriber.Option[0]));
    }

    private <V> NamedTopic<V> getTopicInternal(InjectionPoint<?> injectionPoint) {
        AnnotationMetadata metadata = injectionPoint.getAnnotationMetadata();
        String sessionName = metadata.getValue(SessionName.class, String.class).orElse("");
        String name = metadata.getValue(Name.class, String.class).orElse(this.getName(injectionPoint));
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Cannot determine topic name. No @Name qualifier and injection point is not named");
        }
        try {
            Session session = (Session)this.beanContext.createBean(Session.class, new Object[]{sessionName});
            return session.getTopic(name);
        }
        catch (Exception e) {
            LOG.error("Error getting NamedTopic " + name + " from session " + sessionName, (Throwable)e);
            throw new IllegalStateException("Failed getting NamedTopic " + name + " from session " + sessionName);
        }
    }

    private String getName(InjectionPoint<?> injectionPoint) {
        if (injectionPoint instanceof Named) {
            return ((Named)injectionPoint).getName();
        }
        return null;
    }
}

