/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.annotation;

import io.micronaut.coherence.annotation.AnnotationLiteral;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Name {
    public String value();

    public boolean regex() default false;

    public static final class Literal
    extends AnnotationLiteral<Name>
    implements Name {
        private final String m_sName;
        private final boolean m_fRegex;

        private Literal(String sName) {
            this(sName, false);
        }

        public Literal(String sName, boolean fRegex) {
            this.m_sName = sName;
            this.m_fRegex = fRegex;
        }

        public static Literal of(String sName) {
            return new Literal(sName);
        }

        @Override
        public String value() {
            return this.m_sName;
        }

        @Override
        public boolean regex() {
            return this.m_fRegex;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Literal literal = (Literal)o;
            return this.m_fRegex == literal.m_fRegex && Objects.equals(this.m_sName, literal.m_sName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.m_sName, this.m_fRegex);
        }
    }
}

