/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.annotation;

import io.micronaut.coherence.annotation.AnnotationLiteral;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Scope {
    public static final String DEFAULT = "";
    public static final String SYSTEM = "$SYS";

    public String value() default "";

    public static final class Literal
    extends AnnotationLiteral<Scope>
    implements Scope {
        private final String m_sValue;

        private Literal(String sValue) {
            this.m_sValue = sValue == null ? Scope.DEFAULT : sValue;
        }

        public static Literal of(String sValue) {
            return new Literal(sValue);
        }

        @Override
        public String value() {
            return this.m_sValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Literal literal = (Literal)o;
            return Objects.equals(this.m_sValue, literal.m_sValue);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.m_sValue);
        }
    }
}

