/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.event;

import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.MapListener;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.function.Remote;
import io.micronaut.coherence.FilterFactories;
import io.micronaut.coherence.MapEventTransformerFactories;
import io.micronaut.coherence.annotation.CacheName;
import io.micronaut.coherence.annotation.Deleted;
import io.micronaut.coherence.annotation.ExtractorBinding;
import io.micronaut.coherence.annotation.FilterBinding;
import io.micronaut.coherence.annotation.Inserted;
import io.micronaut.coherence.annotation.Lite;
import io.micronaut.coherence.annotation.MapEventTransformerBinding;
import io.micronaut.coherence.annotation.MapName;
import io.micronaut.coherence.annotation.ScopeName;
import io.micronaut.coherence.annotation.ServiceName;
import io.micronaut.coherence.annotation.SessionName;
import io.micronaut.coherence.annotation.Synchronous;
import io.micronaut.coherence.annotation.Updated;
import io.micronaut.coherence.event.ExecutableMethodMapListener;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

class AnnotatedMapListener<K, V>
implements MapListener<K, V>,
Comparable<AnnotatedMapListener<?, ?>> {
    public static final String WILD_CARD = "*";
    private final ExecutableMethodMapListener<K, V, ?, ?> observer;
    private final String cacheName;
    private final String serviceName;
    private final String scopeName;
    private final EnumSet<Type> eventTypes = EnumSet.noneOf(Type.class);
    private final Set<Annotation> filterAnnotations;
    private final Set<Annotation> transformerAnnotations;
    private final Set<Annotation> extractorAnnotations;
    private String session;
    private boolean liteEvents;
    private boolean synchronousEvents;
    private Filter<?> filter;
    private MapEventTransformer<K, V, ?> transformer;

    AnnotatedMapListener(ExecutableMethodMapListener<K, V, ?, ?> observer, Set<Annotation> annotations) {
        this.observer = observer;
        String cacheName = WILD_CARD;
        String serviceName = WILD_CARD;
        String scopeName = null;
        for (Annotation a2 : observer.getObservedQualifiers()) {
            if (a2 instanceof CacheName) {
                cacheName = ((CacheName)a2).value();
                continue;
            }
            if (a2 instanceof MapName) {
                cacheName = ((MapName)a2).value();
                continue;
            }
            if (a2 instanceof ServiceName) {
                serviceName = ((ServiceName)a2).value();
                continue;
            }
            if (a2 instanceof ScopeName) {
                scopeName = ((ScopeName)a2).value();
                continue;
            }
            if (a2 instanceof Inserted) {
                this.addType(Type.INSERTED);
                continue;
            }
            if (a2 instanceof Updated) {
                this.addType(Type.UPDATED);
                continue;
            }
            if (a2 instanceof Deleted) {
                this.addType(Type.DELETED);
                continue;
            }
            if (a2 instanceof SessionName) {
                this.session = ((SessionName)a2).value();
                continue;
            }
            if (a2 instanceof Lite) {
                this.liteEvents = true;
                continue;
            }
            if (!(a2 instanceof Synchronous)) continue;
            this.synchronousEvents = true;
        }
        if (annotations.contains(Lite.Literal.INSTANCE)) {
            this.liteEvents = true;
        }
        if (annotations.contains(Synchronous.Literal.INSTANCE)) {
            this.synchronousEvents = true;
        }
        this.filterAnnotations = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(FilterBinding.class)).collect(Collectors.toSet());
        this.extractorAnnotations = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class)).collect(Collectors.toSet());
        this.transformerAnnotations = annotations.stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).collect(Collectors.toSet());
        this.cacheName = cacheName;
        this.serviceName = serviceName;
        this.scopeName = scopeName;
    }

    public void entryInserted(MapEvent<K, V> event) {
        this.handle(Type.INSERTED, event);
    }

    public void entryUpdated(MapEvent<K, V> event) {
        this.handle(Type.UPDATED, event);
    }

    public void entryDeleted(MapEvent<K, V> event) {
        this.handle(Type.DELETED, event);
    }

    @Override
    public int compareTo(AnnotatedMapListener<?, ?> other) {
        int result = SafeComparator.compareSafe((Comparator)Remote.Comparator.naturalOrder(), (Object)this.session, (Object)other.session);
        if (result == 0 && (result = SafeComparator.compareSafe((Comparator)Remote.Comparator.naturalOrder(), (Object)this.cacheName, (Object)other.cacheName)) == 0) {
            result = SafeComparator.compareSafe((Comparator)Remote.Comparator.naturalOrder(), (Object)this.serviceName, (Object)other.serviceName);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotatedMapListener)) {
            return false;
        }
        AnnotatedMapListener that = (AnnotatedMapListener)o;
        return this.liteEvents == that.liteEvents && this.synchronousEvents == that.synchronousEvents && Objects.equals(this.observer, that.observer) && Objects.equals(this.getCacheName(), that.getCacheName()) && Objects.equals(this.getServiceName(), that.getServiceName()) && Objects.equals(this.getScopeName(), that.getScopeName()) && Objects.equals(this.eventTypes, that.eventTypes) && Objects.equals(this.filterAnnotations, that.filterAnnotations) && Objects.equals(this.transformerAnnotations, that.transformerAnnotations) && Objects.equals(this.extractorAnnotations, that.extractorAnnotations) && Objects.equals(this.session, that.session) && Objects.equals(this.getFilter(), that.getFilter()) && Objects.equals(this.getTransformer(), that.getTransformer());
    }

    public int hashCode() {
        return Objects.hash(this.observer, this.getCacheName(), this.getServiceName(), this.getScopeName(), this.eventTypes, this.filterAnnotations, this.transformerAnnotations, this.extractorAnnotations, this.session, this.liteEvents, this.synchronousEvents, this.getFilter(), this.getTransformer());
    }

    public String getSessionName() {
        return this.session;
    }

    public boolean hasFilterAnnotation() {
        return this.filterAnnotations != null && !this.filterAnnotations.isEmpty();
    }

    public void resolveFilter(FilterFactories producer) {
        if (this.filter == null && this.filterAnnotations != null && !this.filterAnnotations.isEmpty()) {
            this.filter = producer.resolve(this.filterAnnotations);
        }
    }

    public boolean hasTransformerAnnotation() {
        return !this.transformerAnnotations.isEmpty() || !this.extractorAnnotations.isEmpty();
    }

    public void resolveTransformer(MapEventTransformerFactories producer) {
        if (this.transformer != null) {
            return;
        }
        if (!this.transformerAnnotations.isEmpty()) {
            this.transformer = producer.resolve(this.transformerAnnotations);
        } else if (!this.extractorAnnotations.isEmpty()) {
            this.transformer = producer.resolve(this.extractorAnnotations);
        }
    }

    public Filter<?> getFilter() {
        return this.filter;
    }

    public MapEventTransformer getTransformer() {
        return this.transformer;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public boolean isWildCardCacheName() {
        return WILD_CARD.equals(this.cacheName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isWildCardServiceName() {
        return WILD_CARD.equals(this.serviceName);
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public boolean isLite() {
        return this.liteEvents;
    }

    public boolean isSynchronous() {
        return this.synchronousEvents;
    }

    private void addType(Type type) {
        this.eventTypes.add(type);
    }

    private boolean isSupported(Type type) {
        return this.eventTypes.isEmpty() || this.eventTypes.contains((Object)type);
    }

    private void handle(Type type, MapEvent<K, V> event) {
        if (this.isSupported(type)) {
            if (this.observer.isAsync()) {
                CompletableFuture.supplyAsync(() -> {
                    this.observer.notify(event);
                    return event;
                });
            } else {
                this.observer.notify(event);
            }
        }
    }

    public String toString() {
        return "AnnotatedMapListener{cacheName='" + this.cacheName + "', serviceName='" + this.serviceName + "', scopeName='" + this.scopeName + "', session='" + this.session + "', observer='" + this.observer + "'}";
    }

    static enum Type {
        INSERTED,
        UPDATED,
        DELETED;

    }
}

