/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.event;

import io.micronaut.coherence.annotation.Synchronous;
import io.micronaut.coherence.event.EventArgumentBinderRegistry;
import io.micronaut.inject.ExecutableMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class BaseExecutableMethodObserver<E, T, R> {
    protected final Supplier<T> beanSupplier;
    protected final ExecutableMethod<T, R> method;
    protected final EventArgumentBinderRegistry<E> binderRegistry;

    protected BaseExecutableMethodObserver(Supplier<T> supplier, ExecutableMethod<T, R> method, EventArgumentBinderRegistry<E> registry) {
        this.beanSupplier = supplier;
        this.method = method;
        this.binderRegistry = registry;
    }

    public String getId() {
        return this.method.toString();
    }

    public Set<Annotation> getObservedQualifiers() {
        return Stream.concat(Arrays.stream(this.method.getTargetMethod().getParameterAnnotations()[0]), Arrays.stream(this.method.getTargetMethod().getAnnotations())).collect(Collectors.toSet());
    }

    public boolean isAsync() {
        return !this.method.hasAnnotation(Synchronous.class);
    }
}

