/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.messaging.binders;

import com.tangosol.net.topic.Position;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Binary;
import io.micronaut.coherence.messaging.binders.ElementBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class DefaultTopicBinder<T>
implements ElementBinder<T> {
    private static final DefaultTopicBinder<?> INSTANCE = new DefaultTopicBinder();
    private final Map<Argument<?>, Function<Subscriber.Element<?>, Object>> defaultResolver = new HashMap();

    public DefaultTopicBinder() {
        Function<Subscriber.Element, Object> channelFunc = Subscriber.Element::getChannel;
        Function<Subscriber.Element, Object> positionFunc = Subscriber.Element::getPosition;
        Function<Subscriber.Element, Object> timestampFunc = Subscriber.Element::getTimestamp;
        Function<Subscriber.Element, Object> timestampLongFunc = e -> e.getTimestamp().toEpochMilli();
        this.defaultResolver.put(Argument.of(Integer.class, (String)"channel"), channelFunc);
        this.defaultResolver.put(Argument.of(Position.class, (String)"position"), positionFunc);
        this.defaultResolver.put(Argument.of(Instant.class, (String)"timestamp"), timestampFunc);
        this.defaultResolver.put(Argument.of(Long.class, (String)"timestamp"), timestampLongFunc);
        this.defaultResolver.put(Argument.of(Integer.TYPE, (String)"channel"), channelFunc);
        this.defaultResolver.put(Argument.of(Long.TYPE, (String)"timestamp"), timestampLongFunc);
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, Subscriber.Element<?> element) {
        Argument argument = context.getArgument();
        Function<Subscriber.Element<?>, Object> f = this.defaultResolver.get(argument);
        if (f != null) {
            Optional<Object> opt = Optional.of(f.apply(element));
            return () -> opt;
        }
        if (argument.getType() == Subscriber.Element.class) {
            Optional<Subscriber.Element<?>> opt = Optional.of(element);
            return () -> opt;
        }
        if (argument.getType() == Binary.class) {
            Optional<Binary> opt = Optional.of(element.getBinaryValue());
            return () -> opt;
        }
        Object value = element.getValue();
        Optional converted = ConversionService.SHARED.convert(value, context);
        return () -> converted;
    }

    public static <T> DefaultTopicBinder<T> instance() {
        return INSTANCE;
    }
}

