/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import io.micronaut.context.Qualifier;
import io.micronaut.inject.BeanType;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Objects;
import java.util.stream.Stream;

class FactoryQualifier<T>
implements Qualifier<T> {
    private final Class<? extends Annotation> type;
    private final Class<? extends Annotation> holder;

    FactoryQualifier(Class<? extends Annotation> cls) {
        this.type = cls;
        Repeatable repeatable = cls.getAnnotation(Repeatable.class);
        this.holder = repeatable == null ? null : repeatable.value();
    }

    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(this::filter);
    }

    <BT extends BeanType<T>> boolean filter(BT bt) {
        if (this.holder == null) {
            return bt.isAnnotationPresent(this.type) && Objects.requireNonNull(bt.getAnnotation(this.type)).getAnnotations("value").isEmpty();
        }
        return bt.isAnnotationPresent(this.holder) && Objects.requireNonNull(bt.getAnnotation(this.holder)).getAnnotations("value").size() == 1;
    }
}

