/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.oracle.coherence.common.base.Classes;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.OperationalContext;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Factory
public class SerializerFactories {
    private final OperationalContext context;

    @Inject
    public SerializerFactories(Cluster cluster) {
        this.context = (OperationalContext)cluster;
    }

    @Named(value="java")
    @Singleton
    public Serializer defaultSerializer() {
        return ((SerializerFactory)this.context.getSerializerMap().get("java")).createSerializer(Classes.getContextClassLoader());
    }

    @Named(value="pof")
    @Singleton
    public Serializer pofSerializer() {
        return ((SerializerFactory)this.context.getSerializerMap().get("pof")).createSerializer(Classes.getContextClassLoader());
    }
}

