/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

abstract class AnnotationLiteral<T extends Annotation>
implements Annotation,
Serializable {
    private static final long serialVersionUID = -3645430766814376616L;
    private volatile transient boolean m_fAnnotationTypeChecked;
    private transient Class<T> m_annotationType;
    private transient Method[] m_aMembers;

    protected AnnotationLiteral() {
        Class<?> thisClass = this.getClass();
        boolean foundAnnotation = false;
        for (Class<?> iClass : thisClass.getInterfaces()) {
            if (!iClass.isAnnotation()) continue;
            foundAnnotation = true;
            break;
        }
        if (!foundAnnotation) {
            throw new IllegalStateException("The subclass " + thisClass.getName() + " of AnnotationLiteral must implement an Annotation");
        }
    }

    private static Class<?> getAnnotationLiteralSubclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.equals(AnnotationLiteral.class)) {
            return clazz;
        }
        if (superclass.equals(Object.class)) {
            return null;
        }
        return AnnotationLiteral.getAnnotationLiteralSubclass(superclass);
    }

    private static <T> Class<T> getTypeParameter(Class<?> annotationLiteralSuperclass) {
        Type result;
        ParameterizedType parameterizedType;
        Type type = annotationLiteralSuperclass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1 && Class.class.equals((Object)(result = parameterizedType.getActualTypeArguments()[0]))) {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private static void setAccessible(AccessibleObject ao) {
        ao.setAccessible(true);
    }

    private static Object invoke(Method method, Object instance) {
        try {
            if (!method.canAccess(instance)) {
                AnnotationLiteral.setAccessible(method);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + String.valueOf(method.getDeclaringClass()), e);
        }
    }

    private Method[] getMembers() {
        if (this.m_aMembers == null) {
            Class<Annotation> annotationType = this.annotationType();
            if (annotationType != null) {
                this.m_aMembers = this.annotationType().getDeclaredMethods();
                if (this.m_aMembers.length > 0 && !this.annotationType().isAssignableFrom(this.getClass())) {
                    throw new RuntimeException(String.valueOf(this.getClass()) + " does not implement the annotation type with members " + this.annotationType().getName());
                }
            } else {
                this.m_aMembers = new Method[0];
            }
        }
        return this.m_aMembers;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        if (!this.m_fAnnotationTypeChecked) {
            this.m_fAnnotationTypeChecked = true;
            Class<?> annotationLiteralSubclass = AnnotationLiteral.getAnnotationLiteralSubclass(this.getClass());
            if (annotationLiteralSubclass == null) {
                throw new RuntimeException(String.valueOf(this.getClass()) + "is not a subclass of AnnotationLiteral");
            }
            this.m_annotationType = AnnotationLiteral.getTypeParameter(annotationLiteralSubclass);
        }
        return this.m_annotationType;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Annotation) {
            Annotation that = (Annotation)other;
            if (Objects.equals(this.annotationType(), that.annotationType())) {
                for (Method member : this.getMembers()) {
                    Object thisValue = AnnotationLiteral.invoke(member, this);
                    Object thatValue = AnnotationLiteral.invoke(member, that);
                    if (!(thisValue instanceof byte[] && thatValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof short[] && thatValue instanceof short[] ? !Arrays.equals((short[])thisValue, (short[])thatValue) : (thisValue instanceof int[] && thatValue instanceof int[] ? !Arrays.equals((int[])thisValue, (int[])thatValue) : (thisValue instanceof long[] && thatValue instanceof long[] ? !Arrays.equals((long[])thisValue, (long[])thatValue) : (thisValue instanceof float[] && thatValue instanceof float[] ? !Arrays.equals((float[])thisValue, (float[])thatValue) : (thisValue instanceof double[] && thatValue instanceof double[] ? !Arrays.equals((double[])thisValue, (double[])thatValue) : (thisValue instanceof char[] && thatValue instanceof char[] ? !Arrays.equals((char[])thisValue, (char[])thatValue) : (thisValue instanceof boolean[] && thatValue instanceof boolean[] ? !Arrays.equals((boolean[])thisValue, (boolean[])thatValue) : (thisValue instanceof Object[] && thatValue instanceof Object[] ? !Arrays.equals((Object[])thisValue, (Object[])thatValue) : !thisValue.equals(thatValue))))))))))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.getMembers()) {
            int memberNameHashCode = 127 * member.getName().hashCode();
            Object value = AnnotationLiteral.invoke(member, this);
            int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : value.hashCode()))))))));
            hashCode += memberNameHashCode ^ memberValueHashCode;
        }
        return hashCode;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NoType {
    }
}

