/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.annotation;

import io.micronaut.coherence.annotation.AnnotationLiteral;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Backlog {
    public Type value();

    public static final class Literal
    extends AnnotationLiteral<Backlog>
    implements Backlog {
        private final Type type;

        private Literal(Type type) {
            this.type = type;
        }

        public static Literal of(Type type) {
            return new Literal(type);
        }

        @Override
        public Type value() {
            return this.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Literal literal = (Literal)o;
            return this.type == literal.type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.type});
        }
    }

    public static enum Type {
        NORMAL,
        EXCESSIVE;

    }
}

