/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.tracing;

import com.tangosol.internal.tracing.PropertySource;
import io.micronaut.coherence.CoherenceContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.StringConvention;
import java.util.Map;
import java.util.stream.Collectors;

public class MicronautPropertySource
implements PropertySource {
    public Map<String, String> getProperties() {
        ApplicationContext applicationContext = CoherenceContext.getApplicationContext();
        Map micronautProps = applicationContext.getProperties("otel", StringConvention.RAW);
        Map<String, String> otelProps = micronautProps.entrySet().stream().collect(Collectors.toMap(e -> "otel." + (String)e.getKey(), e -> e.getValue().toString()));
        if (!otelProps.containsKey("otel.service.name")) {
            otelProps.put("otel.service.name", NameUtils.hyphenate((String)applicationContext.getProperty("micronaut.application.name", String.class).orElse("micronaut.coherence")));
        }
        return otelProps;
    }
}

