/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.condition.RequiresHibernateEntities;
import io.micronaut.configuration.hibernate.jpa.scope.CurrentSession;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jdbc.DataSourceResolver;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.validation.ValidatorFactory;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class EntityManagerFactoryBean {
    private static final Logger LOG = LoggerFactory.getLogger(EntityManagerFactoryBean.class);
    private final JpaConfiguration jpaConfiguration;
    private final Environment environment;
    private final BeanLocator beanLocator;
    private Interceptor hibernateInterceptor;

    public EntityManagerFactoryBean(JpaConfiguration jpaConfiguration, Environment environment, BeanLocator beanLocator) {
        this.jpaConfiguration = jpaConfiguration;
        this.environment = environment;
        this.beanLocator = beanLocator;
    }

    @Inject
    public void setHibernateInterceptor(@Nullable Interceptor hibernateInterceptor) {
        this.hibernateInterceptor = hibernateInterceptor;
    }

    @EachBean(value=DataSource.class)
    protected StandardServiceRegistry hibernateStandardServiceRegistry(@Parameter String dataSourceName, DataSource dataSource) {
        DataSourceResolver dataSourceResolver = this.beanLocator.findBean(DataSourceResolver.class).orElse(null);
        if (dataSourceResolver != null) {
            dataSource = dataSourceResolver.resolve(dataSource);
        }
        LinkedHashMap<String, Object> additionalSettings = new LinkedHashMap<String, Object>();
        additionalSettings.put("hibernate.connection.datasource", dataSource);
        additionalSettings.put("hibernate.current_session_context_class", "org.springframework.orm.hibernate5.SpringSessionContext");
        additionalSettings.put("hibernate.session_factory_name", dataSourceName);
        additionalSettings.put("hibernate.session_factory_name_is_jndi", false);
        JpaConfiguration jpaConfiguration = this.beanLocator.findBean(JpaConfiguration.class, Qualifiers.byName((String)dataSourceName)).orElse(this.jpaConfiguration);
        return jpaConfiguration.buildStandardServiceRegistry(additionalSettings);
    }

    @EachBean(value=StandardServiceRegistry.class)
    @RequiresHibernateEntities
    protected MetadataSources hibernateMetadataSources(@Parameter JpaConfiguration jpaConfiguration, StandardServiceRegistry standardServiceRegistry) {
        MetadataSources metadataSources = this.createMetadataSources(standardServiceRegistry);
        JpaConfiguration.EntityScanConfiguration entityScanConfiguration = jpaConfiguration.getEntityScanConfiguration();
        entityScanConfiguration.findEntities().forEach(arg_0 -> ((MetadataSources)metadataSources).addAnnotatedClass(arg_0));
        return metadataSources;
    }

    @EachBean(value=MetadataSources.class)
    @Requires(beans={MetadataSources.class})
    protected SessionFactoryBuilder hibernateSessionFactoryBuilder(MetadataSources metadataSources, @Nullable ValidatorFactory validatorFactory) {
        Metadata metadata = metadataSources.buildMetadata();
        SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        if (validatorFactory != null) {
            sessionFactoryBuilder.applyValidatorFactory((Object)validatorFactory);
        }
        if (this.hibernateInterceptor != null) {
            sessionFactoryBuilder.applyInterceptor(this.hibernateInterceptor);
        }
        return sessionFactoryBuilder;
    }

    @Context
    @Requires(beans={SessionFactoryBuilder.class})
    @Bean(preDestroy="close")
    @EachBean(value=SessionFactoryBuilder.class)
    protected SessionFactory hibernateSessionFactory(SessionFactoryBuilder sessionFactoryBuilder) {
        return sessionFactoryBuilder.build();
    }

    @EachBean(value=SessionFactory.class)
    @CurrentSession
    protected Session currentSession(@Parameter String dataSource, SessionFactory sessionFactory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up current Hibernate session for datasource: {}", (Object)dataSource);
        }
        return sessionFactory.getCurrentSession();
    }

    protected MetadataSources createMetadataSources(@Nonnull StandardServiceRegistry serviceRegistry) {
        return new MetadataSources((ServiceRegistry)serviceRegistry);
    }
}

