/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.validator;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.TypeHint;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;

@Factory
@Requires(classes={HibernateValidator.class})
@TypeHint(value={HibernateValidator.class})
public class ValidatorFactoryProvider {
    @Inject
    protected Optional<MessageInterpolator> messageInterpolator = Optional.empty();
    @Inject
    protected Optional<TraversableResolver> traversableResolver = Optional.empty();
    @Inject
    protected Optional<ConstraintValidatorFactory> constraintValidatorFactory = Optional.empty();
    @Inject
    protected Optional<ParameterNameProvider> parameterNameProvider = Optional.empty();
    @Value(value="${hibernate.validator.ignore-xml-configuration:true}")
    protected boolean ignoreXmlConfiguration = true;

    @Singleton
    @Requires(classes={HibernateValidator.class})
    ValidatorFactory validatorFactory(Optional<Environment> environment) {
        Configuration validatorConfiguration = Validation.byDefaultProvider().configure();
        this.messageInterpolator.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).messageInterpolator(arg_0));
        this.traversableResolver.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).traversableResolver(arg_0));
        this.constraintValidatorFactory.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).constraintValidatorFactory(arg_0));
        this.parameterNameProvider.ifPresent(arg_0 -> ((Configuration)validatorConfiguration).parameterNameProvider(arg_0));
        if (this.ignoreXmlConfiguration) {
            validatorConfiguration.ignoreXmlConfiguration();
        }
        environment.ifPresent(env -> {
            Optional config = env.getProperty("hibernate.validator", Properties.class);
            config.ifPresent(properties -> {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    Object value = entry.getValue();
                    if (value == null) continue;
                    validatorConfiguration.addProperty("hibernate.validator." + entry.getKey(), value.toString());
                }
            });
        });
        return validatorConfiguration.buildValidatorFactory();
    }
}

