/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.validator;

import io.micronaut.context.BeanContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.validation.ParameterNameProvider;

@Singleton
public class DefaultParameterNameProvider
implements ParameterNameProvider {
    private static final Set<String> INTERNAL_CLASS_NAMES = CollectionUtils.setOf((Object[])new String[]{Object.class.getName(), "groovy.lang.GroovyObject"});
    private final BeanContext beanContext;

    public DefaultParameterNameProvider(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public List<String> getParameterNames(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (INTERNAL_CLASS_NAMES.contains(declaringClass.getName())) {
            return this.doGetParameterNames(constructor);
        }
        Optional definition = this.beanContext.findBeanDefinition(declaringClass);
        return definition.map(def -> Arrays.stream(def.getConstructor().getArguments()).map(Argument::getName).collect(Collectors.toList())).orElse(this.defaultParameterTypes(parameterTypes));
    }

    public List<String> getParameterNames(Method method) {
        Class[] parameterTypes = method.getParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        if (INTERNAL_CLASS_NAMES.contains(declaringClass.getName())) {
            return this.doGetParameterNames(method);
        }
        Optional executableMethod = this.beanContext.findExecutableMethod(declaringClass, method.getName(), parameterTypes);
        return executableMethod.map(m -> Arrays.asList(m.getArgumentNames())).orElse(this.defaultParameterTypes(parameterTypes));
    }

    protected List<String> defaultParameterTypes(Class<?>[] parameterTypes) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            names.add("arg" + i);
        }
        return names;
    }

    private List<String> doGetParameterNames(Executable executable) {
        Parameter[] parameters = executable.getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.length);
        for (Parameter parameter : parameters) {
            parameterNames.add(parameter.getName());
        }
        return Collections.unmodifiableList(parameterNames);
    }
}

