/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.hikari;

import com.zaxxer.hikari.HikariConfig;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.jdbc.CalculatedSettings;
import javax.annotation.PostConstruct;

@EachProperty(value="datasources", primary="default")
public class DatasourceConfiguration
extends HikariConfig
implements BasicJdbcConfiguration {
    private CalculatedSettings calculatedSettings;
    private String name;

    public DatasourceConfiguration(@Parameter String name) {
        this.name = name;
        this.calculatedSettings = new CalculatedSettings((BasicJdbcConfiguration)this);
    }

    @PostConstruct
    void postConstruct() {
        if (this.getConfiguredUrl() == null) {
            this.setUrl(this.getUrl());
        }
        if (this.getConfiguredDriverClassName() == null) {
            this.setDriverClassName(this.getDriverClassName());
        }
        if (this.getConfiguredUsername() == null) {
            this.setUsername(this.getUsername());
        }
        if (this.getConfiguredPassword() == null) {
            this.setPassword(this.getPassword());
        }
        if (this.getConfiguredValidationQuery() == null) {
            this.setValidationQuery(this.getValidationQuery());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getConfiguredUrl() {
        return this.getJdbcUrl();
    }

    public String getUrl() {
        return this.calculatedSettings.getUrl();
    }

    public void setUrl(String url) {
        this.setJdbcUrl(url);
    }

    public String getConfiguredDriverClassName() {
        return super.getDriverClassName();
    }

    public String getDriverClassName() {
        return this.calculatedSettings.getDriverClassName();
    }

    public String getConfiguredUsername() {
        return super.getUsername();
    }

    public String getUsername() {
        return this.calculatedSettings.getUsername();
    }

    public String getConfiguredPassword() {
        return super.getPassword();
    }

    public String getPassword() {
        return this.calculatedSettings.getPassword();
    }

    public String getConfiguredValidationQuery() {
        return this.getConnectionTestQuery();
    }

    public String getValidationQuery() {
        return this.calculatedSettings.getValidationQuery();
    }

    public void setValidationQuery(String validationQuery) {
        this.setConnectionTestQuery(validationQuery);
    }

    public String getJndiName() {
        return this.getDataSourceJNDI();
    }

    public void setJndiName(String jndiName) {
        this.setDataSourceJNDI(jndiName);
    }
}

