/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.tomcat;

import io.micronaut.configuration.jdbc.tomcat.DatasourceConfiguration;
import io.micronaut.configuration.jdbc.tomcat.metadata.TomcatDataSourcePoolMetadata;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.jdbc.DataSourceResolver;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class DatasourceFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceFactory.class);
    private List<DataSource> dataSources = new ArrayList<DataSource>(2);
    private final DataSourceResolver dataSourceResolver;

    public DatasourceFactory(@Nullable DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver == null ? DataSourceResolver.DEFAULT : dataSourceResolver;
    }

    @Context
    @EachBean(value=DatasourceConfiguration.class)
    public javax.sql.DataSource dataSource(DatasourceConfiguration datasourceConfiguration) {
        DataSource ds = new DataSource((PoolConfiguration)datasourceConfiguration);
        this.dataSources.add(ds);
        return ds;
    }

    @EachBean(value=javax.sql.DataSource.class)
    @Requires(beans={DatasourceConfiguration.class})
    public TomcatDataSourcePoolMetadata tomcatPoolDataSourceMetadataProvider(javax.sql.DataSource dataSource) {
        TomcatDataSourcePoolMetadata dataSourcePoolMetadata = null;
        javax.sql.DataSource resolved = this.dataSourceResolver.resolve(dataSource);
        if (resolved instanceof DataSource) {
            dataSourcePoolMetadata = new TomcatDataSourcePoolMetadata((DataSource)resolved);
        }
        return dataSourcePoolMetadata;
    }

    @Override
    @PreDestroy
    public void close() {
        for (DataSource dataSource : this.dataSources) {
            try {
                dataSource.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Error closing data source [" + dataSource + "]: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

