/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.tomcat;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.jdbc.BasicJdbcConfiguration;
import io.micronaut.jdbc.CalculatedSettings;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.tomcat.jdbc.pool.PoolProperties;

@EachProperty(value="datasources", primary="default")
public class DatasourceConfiguration
extends PoolProperties
implements BasicJdbcConfiguration {
    private CalculatedSettings calculatedSettings;

    public DatasourceConfiguration(@Parameter String name) {
        this.setName(name);
        this.calculatedSettings = new CalculatedSettings((BasicJdbcConfiguration)this);
    }

    @PostConstruct
    void postConstruct() {
        this.getDriverClassName();
        this.getUrl();
        this.getUsername();
        this.getPassword();
        this.getValidationQuery();
    }

    public void setDbProperties(@MapFormat(keyFormat=StringConvention.UNDER_SCORE_SEPARATED) Properties dbProperties) {
        super.setDbProperties(dbProperties);
    }

    public String getDriverClassName() {
        return this.calculatedSettings.getDriverClassName();
    }

    public String getConfiguredDriverClassName() {
        return super.getDriverClassName();
    }

    public String getUrl() {
        return this.calculatedSettings.getUrl();
    }

    public String getConfiguredUrl() {
        return super.getUrl();
    }

    public String getUsername() {
        return this.calculatedSettings.getUsername();
    }

    public String getConfiguredUsername() {
        return super.getUsername();
    }

    public String getPassword() {
        return this.calculatedSettings.getPassword();
    }

    public String getConfiguredPassword() {
        return super.getPassword();
    }

    public String getValidationQuery() {
        return this.calculatedSettings.getValidationQuery();
    }

    public String getConfiguredValidationQuery() {
        return super.getValidationQuery();
    }

    public String getJndiName() {
        return this.getDataSourceJNDI();
    }

    public void setJndiName(String jndiName) {
        this.setDataSourceJNDI(jndiName);
    }
}

