/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jdbc.tomcat.metadata;

import io.micronaut.jdbc.metadata.AbstractDataSourcePoolMetadata;
import java.util.Optional;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;

public class TomcatDataSourcePoolMetadata
extends AbstractDataSourcePoolMetadata<DataSource> {
    private final ConnectionPool connectionPool;

    public TomcatDataSourcePoolMetadata(DataSource dataSource) {
        super((javax.sql.DataSource)dataSource);
        this.connectionPool = dataSource.getPool();
    }

    public Integer getIdle() {
        return Optional.ofNullable(this.connectionPool).map(ConnectionPool::getIdle).orElse(0);
    }

    public Integer getActive() {
        return Optional.ofNullable(this.connectionPool).map(ConnectionPool::getActive).orElse(0);
    }

    public final long getBorrowed() {
        return Optional.ofNullable(this.connectionPool).map(ConnectionPool::getBorrowedCount).orElse(0L);
    }

    public final long getReleasedCount() {
        return Optional.ofNullable(this.connectionPool).map(ConnectionPool::getReleasedCount).orElse(0L);
    }

    public Integer getMax() {
        return ((DataSource)this.getDataSource()).getMaxActive();
    }

    public Integer getMin() {
        return ((DataSource)this.getDataSource()).getMinIdle();
    }

    public String getValidationQuery() {
        return ((DataSource)this.getDataSource()).getValidationQuery();
    }

    public Boolean getDefaultAutoCommit() {
        return Optional.ofNullable(((DataSource)this.getDataSource()).isDefaultAutoCommit()).orElse(false);
    }
}

