/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq.spring;

import io.micronaut.configuration.jooq.spring.SpringTransaction;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import org.jooq.Transaction;
import org.jooq.TransactionContext;
import org.jooq.TransactionProvider;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Requires(classes={PlatformTransactionManager.class})
@EachBean(value=PlatformTransactionManager.class)
public class SpringTransactionProvider
implements TransactionProvider {
    private final PlatformTransactionManager transactionManager;

    public SpringTransactionProvider(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin(TransactionContext context) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(6);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        context.transaction((Transaction)new SpringTransaction(status));
    }

    public void commit(TransactionContext ctx) {
        this.transactionManager.commit(this.getTransactionStatus(ctx));
    }

    public void rollback(TransactionContext ctx) {
        this.transactionManager.rollback(this.getTransactionStatus(ctx));
    }

    private TransactionStatus getTransactionStatus(TransactionContext ctx) {
        SpringTransaction transaction = (SpringTransaction)ctx.transaction();
        return transaction.getTxStatus();
    }
}

