/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq;

import io.micronaut.configuration.jooq.JooqConfigurationProperties;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.inject.qualifiers.Qualifiers;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DiagnosticsListenerProvider;
import org.jooq.ExecuteListenerProvider;
import org.jooq.ExecutorProvider;
import org.jooq.MetaProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordUnmapperProvider;
import org.jooq.TransactionListenerProvider;
import org.jooq.TransactionProvider;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;

@Factory
public class JooqConfigurationFactory {
    @EachBean(value=DataSource.class)
    public Configuration jooqConfiguration(@Parameter String name, DataSource dataSource, @Parameter @Nullable TransactionProvider transactionProvider, @Parameter @Nullable Settings settings, @Parameter @Nullable ExecutorProvider executorProvider, @Parameter @Nullable RecordMapperProvider recordMapperProvider, @Parameter @Nullable RecordUnmapperProvider recordUnmapperProvider, @Parameter @Nullable MetaProvider metaProvider, ApplicationContext ctx) {
        DefaultConfiguration configuration = new DefaultConfiguration();
        JooqConfigurationProperties properties = ctx.findBean(JooqConfigurationProperties.class, Qualifiers.byName((String)name)).orElseGet(JooqConfigurationProperties::new);
        configuration.setSQLDialect(properties.determineSqlDialect(dataSource));
        configuration.setDataSource(dataSource);
        if (transactionProvider != null) {
            configuration.setTransactionProvider(transactionProvider);
        }
        if (settings != null) {
            configuration.setSettings(settings);
        }
        if (executorProvider != null) {
            configuration.setExecutorProvider(executorProvider);
        }
        if (recordMapperProvider != null) {
            configuration.setRecordMapperProvider(recordMapperProvider);
        }
        if (recordUnmapperProvider != null) {
            configuration.setRecordUnmapperProvider(recordUnmapperProvider);
        }
        if (metaProvider != null) {
            configuration.setMetaProvider(metaProvider);
        }
        configuration.setExecuteListenerProvider(ctx.getBeansOfType(ExecuteListenerProvider.class, Qualifiers.byName((String)name)).toArray(new ExecuteListenerProvider[0]));
        configuration.setRecordListenerProvider(ctx.getBeansOfType(RecordListenerProvider.class, Qualifiers.byName((String)name)).toArray(new RecordListenerProvider[0]));
        configuration.setVisitListenerProvider(ctx.getBeansOfType(VisitListenerProvider.class, Qualifiers.byName((String)name)).toArray(new VisitListenerProvider[0]));
        configuration.setTransactionListenerProvider(ctx.getBeansOfType(TransactionListenerProvider.class, Qualifiers.byName((String)name)).toArray(new TransactionListenerProvider[0]));
        configuration.setDiagnosticsListenerProvider(ctx.getBeansOfType(DiagnosticsListenerProvider.class, Qualifiers.byName((String)name)).toArray(new DiagnosticsListenerProvider[0]));
        return configuration;
    }

    @EachBean(value=Configuration.class)
    public DSLContext dslContext(Configuration configuration) {
        return new DefaultDSLContext(configuration);
    }
}

