/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.jooq.spring;

import io.micronaut.core.annotation.Internal;
import java.sql.SQLException;
import org.jooq.ExecuteContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DefaultExecuteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

@Internal
class JooqExceptionTranslator
extends DefaultExecuteListener {
    private static final Logger LOG = LoggerFactory.getLogger(JooqExceptionTranslator.class);

    JooqExceptionTranslator() {
    }

    public void exception(ExecuteContext context) {
        SQLExceptionTranslator translator = this.getTranslator(context);
        for (SQLException exception = context.sqlException(); exception != null; exception = exception.getNextException()) {
            this.handle(context, translator, exception);
        }
    }

    private SQLExceptionTranslator getTranslator(ExecuteContext context) {
        String dbName;
        SQLDialect dialect = context.configuration().dialect();
        if (dialect != null && dialect.thirdParty() != null && (dbName = dialect.thirdParty().springDbName()) != null) {
            return new SQLErrorCodeSQLExceptionTranslator(dbName);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    private void handle(ExecuteContext context, SQLExceptionTranslator translator, SQLException exception) {
        DataAccessException translated = this.translate(context, translator, exception);
        if (exception.getNextException() == null) {
            context.exception((RuntimeException)translated);
        } else {
            LOG.error("Execution of SQL statement failed.", (Throwable)translated);
        }
    }

    private DataAccessException translate(ExecuteContext context, SQLExceptionTranslator translator, SQLException exception) {
        return translator.translate("jOOQ", context.sql(), exception);
    }
}

