/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.client.VipAddressResolver;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import io.micronaut.context.env.Environment;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public abstract class AbstractRibbonClientConfig
implements IClientConfig {
    public static final String PREFIX = "ribbon";
    private final Environment environment;
    private Map<IClientConfigKey, Object> customSettings = new ConcurrentHashMap<IClientConfigKey, Object>();
    private VipAddressResolver resolver = null;

    public AbstractRibbonClientConfig(Environment environment) {
        this.environment = environment;
    }

    @Inject
    public void setVipAddressResolver(Optional<VipAddressResolver> resolver) {
        if (resolver.isPresent()) {
            this.resolver = resolver.get();
        }
    }

    public String getClientName() {
        return "default";
    }

    public String getNameSpace() {
        return PREFIX;
    }

    public void loadProperties(String clientName) {
    }

    public void loadDefaultValues() {
    }

    public Map<String, Object> getProperties() {
        Map map = this.environment.getProperty(this.getNameSpace(), Argument.of(Map.class, (Class[])new Class[]{String.class, Object.class})).orElse(Collections.EMPTY_MAP);
        LinkedHashMap<String, Object> all = new LinkedHashMap<String, Object>(map);
        for (Map.Entry<IClientConfigKey, Object> entry : this.customSettings.entrySet()) {
            all.put(entry.getKey().key(), entry.getValue());
        }
        return all;
    }

    @Deprecated
    public void setProperty(IClientConfigKey key, Object value) {
        this.set(key, value);
    }

    @Deprecated
    public Object getProperty(IClientConfigKey key) {
        return this.get(key, null);
    }

    @Deprecated
    public Object getProperty(IClientConfigKey key, Object defaultVal) {
        return this.get(key, defaultVal);
    }

    public boolean containsProperty(IClientConfigKey key) {
        return key != null && (this.customSettings.containsKey(key) || this.environment.get((CharSequence)this.qualifyKey(key), key.type()).isPresent());
    }

    public int getPropertyAsInteger(IClientConfigKey key, int defaultValue) {
        return this.get(key, Integer.class, defaultValue);
    }

    public String getPropertyAsString(IClientConfigKey key, String defaultValue) {
        return this.get(key, String.class, defaultValue);
    }

    public boolean getPropertyAsBoolean(IClientConfigKey key, boolean defaultValue) {
        return this.get(key, Boolean.class, defaultValue);
    }

    public <T> T get(IClientConfigKey<T> key) {
        return this.get(key, null);
    }

    public <T> T get(IClientConfigKey<T> key, T defaultValue) {
        Class type = key.type();
        return this.get(key, type, defaultValue);
    }

    public <T> IClientConfig set(IClientConfigKey<T> key, T value) {
        if (key != null) {
            if (value == null) {
                this.customSettings.remove(key);
            } else {
                this.customSettings.put(key, value);
            }
        }
        return this;
    }

    public String resolveDeploymentContextbasedVipAddresses() {
        String deploymentContextBasedVipAddressesMacro = (String)this.getProperty(CommonClientConfigKey.DeploymentContextBasedVipAddresses);
        if (deploymentContextBasedVipAddressesMacro == null) {
            return null;
        }
        return this.getVipAddressResolver().resolve(deploymentContextBasedVipAddressesMacro, (IClientConfig)this);
    }

    protected <T> T get(IClientConfigKey<T> key, Class<T> type, T defaultValue) {
        if (key == null) {
            return null;
        }
        if (this.customSettings.containsKey(key)) {
            return ConversionService.SHARED.convert(this.customSettings.get(key), type).orElse(defaultValue);
        }
        return (T)this.environment.getProperty(this.qualifyKey(key), type, defaultValue);
    }

    protected String qualifyKey(IClientConfigKey key) {
        String property = NameUtils.hyphenate((String)key.key());
        return this.getNameSpace() + "." + property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VipAddressResolver getVipAddressResolver() {
        if (this.resolver == null) {
            AbstractRibbonClientConfig abstractRibbonClientConfig = this;
            synchronized (abstractRibbonClientConfig) {
                if (this.resolver == null) {
                    this.resolver = (VipAddressResolver)InstantiationUtils.instantiate((String)((String)this.getProperty(CommonClientConfigKey.VipAddressResolverClassName)), VipAddressResolver.class);
                }
            }
        }
        return this.resolver;
    }
}

