/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import io.micronaut.configuration.ribbon.RibbonServer;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryClientServerList
extends AbstractServerList<Server> {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryClientServerList.class);
    private final DiscoveryClient discoveryClient;
    private final String serviceID;

    public DiscoveryClientServerList(DiscoveryClient discoveryClient, String serviceID) {
        this.discoveryClient = discoveryClient;
        this.serviceID = serviceID;
    }

    public List<Server> getInitialListOfServers() {
        List<Server> serverList = this.resolveServerList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved initial list of servers from DiscoveryClient [{}]: {}", (Object)this.discoveryClient.getDescription(), serverList);
        }
        return serverList;
    }

    public List<Server> getUpdatedListOfServers() {
        List<Server> serverList = this.resolveServerList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved updated list of servers from DiscoveryClient [{}]: {}", (Object)this.discoveryClient.getDescription(), serverList);
        }
        return serverList;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }

    protected List<Server> resolveServerList() {
        List serviceInstances = (List)Flowable.fromPublisher((Publisher)this.discoveryClient.getInstances(this.serviceID)).blockingFirst();
        ArrayList<Server> servers = new ArrayList<Server>(serviceInstances.size());
        for (ServiceInstance serviceInstance : serviceInstances) {
            RibbonServer server = new RibbonServer(serviceInstance);
            servers.add(server);
        }
        return servers;
    }
}

