/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.DummyPing;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ZoneAffinityServerListFilter;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;

@Factory
@Requires(classes={IClientConfig.class})
public class RibbonDefaultsFactory {
    @Prototype
    @Primary
    @Requires(missingBeans={ServerListFilter.class})
    ServerListFilter defaultServerListFilter(IClientConfig defaultConfig) {
        return new ZoneAffinityServerListFilter(defaultConfig);
    }

    @Prototype
    @Primary
    @Requires(missingBeans={IPing.class})
    IPing defaultPing() {
        return new DummyPing();
    }

    @Prototype
    @Primary
    @Requires(missingBeans={IRule.class})
    IRule defaultRule(IClientConfig clientConfig) {
        ZoneAvoidanceRule zoneAvoidanceRule = new ZoneAvoidanceRule();
        zoneAvoidanceRule.initWithNiwsConfig(clientConfig);
        return zoneAvoidanceRule;
    }
}

