/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.client.ClientException;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import io.micronaut.configuration.ribbon.RibbonServiceInstance;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.exceptions.HttpClientException;
import java.util.List;
import org.reactivestreams.Publisher;

public class RibbonLoadBalancer
implements LoadBalancer,
ILoadBalancer {
    private final ILoadBalancer loadBalancer;
    private final LoadBalancerContext loadBalancerContext;
    private final IClientConfig clientConfig;

    public RibbonLoadBalancer(IClientConfig niwsClientConfig, ServerList serverList, ServerListFilter serverListFilter, IRule rule, IPing ping) {
        this.loadBalancer = this.createLoadBalancer(niwsClientConfig, rule, ping, serverListFilter, (ServerList<Server>)serverList);
        this.loadBalancerContext = new LoadBalancerContext(this.loadBalancer, niwsClientConfig);
        this.loadBalancerContext.initWithNiwsConfig(niwsClientConfig);
        this.clientConfig = niwsClientConfig;
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public LoadBalancerContext getLoadBalancerContext() {
        return this.loadBalancerContext;
    }

    public Publisher<ServiceInstance> select(Object discriminator) {
        try {
            Server server = this.loadBalancerContext.getServerFromLoadBalancer(null, discriminator);
            RibbonServiceInstance ribbonServiceInstance = new RibbonServiceInstance(server, this.loadBalancerContext);
            return Publishers.just((Object)ribbonServiceInstance);
        }
        catch (ClientException e) {
            return Publishers.just((Throwable)new HttpClientException("Error retrieving Ribbon server: " + e.getMessage(), (Throwable)e));
        }
    }

    public void addServers(List<Server> newServers) {
        this.loadBalancer.addServers(newServers);
    }

    public Server chooseServer(Object key) {
        return this.loadBalancer.chooseServer(key);
    }

    public void markServerDown(Server server) {
        this.loadBalancer.markServerDown(server);
    }

    public List<Server> getServerList(boolean availableOnly) {
        return this.loadBalancer.getServerList(availableOnly);
    }

    public List<Server> getReachableServers() {
        return this.loadBalancer.getReachableServers();
    }

    public List<Server> getAllServers() {
        return this.loadBalancer.getAllServers();
    }

    protected ILoadBalancer createLoadBalancer(IClientConfig clientConfig, IRule rule, IPing ping, ServerListFilter serverListFilter, ServerList<Server> serverList) {
        return new ZoneAwareLoadBalancer(clientConfig, rule, ping, serverList, serverListFilter, (ServerListUpdater)new PollingServerListUpdater(clientConfig));
    }
}

