/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import hu.akarnokd.rxjava.interop.RxJavaInterop;
import io.micronaut.configuration.ribbon.RibbonExecutionListenerAdapter;
import io.micronaut.configuration.ribbon.RibbonLoadBalancer;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ssl.NettyClientSslBuilder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.HttpClientFilter;
import io.reactivex.Flowable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import rx.Observable;

@Prototype
@Requires(classes={IClientConfig.class})
@Primary
@Replaces(value=DefaultHttpClient.class)
public class RibbonRxHttpClient
extends DefaultHttpClient {
    private final RibbonLoadBalancer loadBalancer;
    private final List<? extends ExecutionListener<?, HttpResponse<?>>> executionListeners;

    @Inject
    public RibbonRxHttpClient(@Parameter LoadBalancer loadBalancer, @Parameter HttpClientConfiguration configuration, @Parameter @Nullable String contextPath, @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<HttpClientFilter> filters, List<RibbonExecutionListenerAdapter> executionListeners) {
        super(loadBalancer, configuration, contextPath, threadFactory, nettyClientSslBuilder, codecRegistry, annotationMetadataResolver, filters);
        this.executionListeners = CollectionUtils.isEmpty(executionListeners) ? Collections.emptyList() : executionListeners;
        this.loadBalancer = loadBalancer instanceof RibbonLoadBalancer ? (RibbonLoadBalancer)loadBalancer : null;
    }

    @Inject
    protected void configure(BeanContext beanContext) {
        super.configure(beanContext);
    }

    public Optional<RibbonLoadBalancer> getLoadBalancer() {
        return Optional.ofNullable(this.loadBalancer);
    }

    public <I, O, E> Flowable<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        if (this.loadBalancer != null) {
            HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
            LoadBalancerCommand<O> loadBalancerCommand = this.buildLoadBalancerCommand();
            Observable requestOperation = loadBalancerCommand.submit(server -> {
                URI newURI = this.loadBalancer.getLoadBalancerContext().reconstructURIWithServer(server, this.resolveRequestURI(request.getUri()));
                return RxJavaInterop.toV1Observable((Publisher)Flowable.fromPublisher((Publisher)Publishers.just((Object)newURI)).switchMap(super.buildExchangePublisher(parentRequest, request, bodyType, errorType)));
            });
            return RxJavaInterop.toV2Flowable((Observable)requestOperation);
        }
        return super.exchange(request, bodyType);
    }

    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(HttpRequest<I> request) {
        if (this.loadBalancer != null) {
            LoadBalancerCommand loadBalancerCommand = this.buildLoadBalancerCommand();
            Observable requestOperation = loadBalancerCommand.submit(server -> {
                URI newURI = this.loadBalancer.getLoadBalancerContext().reconstructURIWithServer(server, this.resolveRequestURI(request.getUri()));
                return RxJavaInterop.toV1Observable((Publisher)Flowable.fromPublisher((Publisher)Publishers.just((Object)newURI)).switchMap(super.buildExchangeStreamPublisher(request)));
            });
            return RxJavaInterop.toV2Flowable((Observable)requestOperation);
        }
        return super.exchangeStream(request);
    }

    public <I> Flowable<ByteBuffer<?>> dataStream(HttpRequest<I> request) {
        if (this.loadBalancer != null) {
            LoadBalancerCommand loadBalancerCommand = this.buildLoadBalancerCommand();
            Observable requestOperation = loadBalancerCommand.submit(server -> {
                URI newURI = this.loadBalancer.getLoadBalancerContext().reconstructURIWithServer(server, this.resolveRequestURI(request.getUri()));
                return RxJavaInterop.toV1Observable((Publisher)Flowable.fromPublisher((Publisher)Publishers.just((Object)newURI)).switchMap(super.buildDataStreamPublisher(request)));
            });
            return RxJavaInterop.toV2Flowable((Observable)requestOperation);
        }
        return super.dataStream(request);
    }

    public <I, O> Flowable<O> jsonStream(HttpRequest<I> request, Argument<O> type) {
        if (this.loadBalancer != null) {
            HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
            LoadBalancerCommand<O> loadBalancerCommand = this.buildLoadBalancerCommand();
            Observable requestOperation = loadBalancerCommand.submit(server -> {
                URI newURI = this.loadBalancer.getLoadBalancerContext().reconstructURIWithServer(server, this.resolveRequestURI(request.getUri()));
                return RxJavaInterop.toV1Observable((Publisher)Flowable.fromPublisher((Publisher)Publishers.just((Object)newURI)).switchMap(super.buildJsonStreamPublisher(parentRequest, request, type)));
            });
            return RxJavaInterop.toV2Flowable((Observable)requestOperation);
        }
        return super.jsonStream(request, type);
    }

    protected <O> LoadBalancerCommand<O> buildLoadBalancerCommand() {
        LoadBalancerCommand.Builder commandBuilder = LoadBalancerCommand.builder();
        commandBuilder.withLoadBalancer(this.loadBalancer.getLoadBalancer()).withClientConfig(this.loadBalancer.getClientConfig());
        if (!this.executionListeners.isEmpty()) {
            commandBuilder.withListeners(this.executionListeners);
        }
        return commandBuilder.build();
    }
}

