/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.loadbalancer.Server;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.health.HealthStatus;

public class RibbonServer
extends Server {
    private final ServiceInstance instance;

    public RibbonServer(ServiceInstance instance) {
        super(instance.getId());
        instance.getZone().ifPresent(arg_0 -> ((RibbonServer)this).setZone(arg_0));
        this.instance = instance;
        boolean isUp = instance.getHealthStatus().equals((Object)HealthStatus.UP);
        this.setAlive(isUp);
        this.setPort(instance.getPort());
        this.setHost(instance.getHost());
        this.setReadyToServe(isUp);
    }

    public String getHost() {
        return this.instance.getHost();
    }

    public int getPort() {
        return this.instance.getPort();
    }

    public String getScheme() {
        return this.instance.isSecure() ? "https" : "http";
    }

    public Server.MetaInfo getMetaInfo() {
        return new Server.MetaInfo(){

            public String getAppName() {
                return RibbonServer.this.instance.getId();
            }

            public String getServerGroup() {
                return RibbonServer.this.instance.getGroup().orElse(null);
            }

            public String getServiceIdForDiscovery() {
                return RibbonServer.this.instance.getId();
            }

            public String getInstanceId() {
                return RibbonServer.this.instance.getInstanceId().orElse(null);
            }
        };
    }
}

