/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon;

import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.health.HealthStatus;
import java.net.URI;
import java.util.Optional;

public class RibbonServiceInstance
implements ServiceInstance {
    private final Server server;
    private final LoadBalancerContext lb;

    public RibbonServiceInstance(Server server, LoadBalancerContext lb) {
        this.server = server;
        this.lb = lb;
    }

    public ConvertibleValues<String> getMetadata() {
        return ConvertibleValues.empty();
    }

    public String getId() {
        return this.server.getMetaInfo().getServiceIdForDiscovery();
    }

    public HealthStatus getHealthStatus() {
        return this.server.isAlive() ? HealthStatus.UP : HealthStatus.DOWN;
    }

    public Optional<String> getInstanceId() {
        return Optional.ofNullable(this.server.getMetaInfo().getInstanceId());
    }

    public URI getURI() {
        return URI.create(this.server.getScheme() + "://" + this.server.getHostPort());
    }

    public boolean isSecure() {
        return this.server.getScheme() != null && this.server.getScheme().equalsIgnoreCase("https");
    }

    public Optional<String> getZone() {
        return Optional.ofNullable(this.server.getZone());
    }

    public Optional<String> getGroup() {
        return Optional.ofNullable(this.server.getMetaInfo().getServerGroup());
    }

    public URI resolve(URI relativeURI) {
        return this.lb.reconstructURIWithServer(this.server, relativeURI);
    }
}

