/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon.discovery;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ConfigurationBasedServerList;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import io.micronaut.configuration.ribbon.DiscoveryClientServerList;
import io.micronaut.configuration.ribbon.RibbonLoadBalancer;
import io.micronaut.configuration.ribbon.discovery.StandardNameClientConfig;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.env.Environment;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.loadbalance.DiscoveryClientLoadBalancerFactory;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;

@Replaces(value=DiscoveryClientLoadBalancerFactory.class)
@Singleton
public class RibbonDiscoveryClientLoadBalancerFactory
extends DiscoveryClientLoadBalancerFactory {
    private final BeanContext beanContext;
    private final IClientConfig defaultClientConfig;
    private final Environment environment;

    public RibbonDiscoveryClientLoadBalancerFactory(DiscoveryClient discoveryClient, BeanContext beanContext, IClientConfig defaultClientConfig, Environment environment) {
        super(discoveryClient);
        this.beanContext = beanContext;
        this.defaultClientConfig = defaultClientConfig;
        this.environment = environment;
    }

    public LoadBalancer create(String serviceID) {
        serviceID = NameUtils.hyphenate((String)serviceID);
        IClientConfig niwsClientConfig = this.beanContext.findBean(IClientConfig.class, Qualifiers.byName((String)serviceID)).orElse(new StandardNameClientConfig(this.environment, serviceID, this.defaultClientConfig));
        IRule rule = this.beanContext.findBean(IRule.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> (IRule)this.beanContext.createBean(IRule.class));
        IPing ping = this.beanContext.findBean(IPing.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> (IPing)this.beanContext.createBean(IPing.class));
        ServerListFilter serverListFilter = this.beanContext.findBean(ServerListFilter.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> (ServerListFilter)this.beanContext.createBean(ServerListFilter.class));
        ServerList<Server> serverList = RibbonDiscoveryClientLoadBalancerFactory.buildServerList(this.beanContext, serviceID, niwsClientConfig, this.getDiscoveryClient());
        if (niwsClientConfig.getPropertyAsBoolean(CommonClientConfigKey.InitializeNFLoadBalancer, true)) {
            return this.createRibbonLoadBalancer(niwsClientConfig, rule, ping, serverListFilter, serverList);
        }
        return super.create(serviceID);
    }

    protected RibbonLoadBalancer createRibbonLoadBalancer(IClientConfig niwsClientConfig, IRule rule, IPing ping, ServerListFilter serverListFilter, ServerList<Server> serverList) {
        return new RibbonLoadBalancer(niwsClientConfig, serverList, serverListFilter, rule, ping);
    }

    private static ServerList<Server> buildServerList(BeanContext beanContext, String serviceID, IClientConfig niwsClientConfig, DiscoveryClient discoveryClient) {
        ConfigurationBasedServerList serverList;
        Optional result = ConversionService.SHARED.convert(niwsClientConfig.get(CommonClientConfigKey.ListOfServers, null), Argument.of(List.class, (Class[])new Class[]{URI.class}));
        List staticServerList = result.orElse(null);
        if (CollectionUtils.isNotEmpty((Collection)staticServerList)) {
            ConfigurationBasedServerList configList = new ConfigurationBasedServerList();
            configList.initWithNiwsConfig(niwsClientConfig);
            serverList = configList;
        } else {
            serverList = beanContext.findBean(ServerList.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> new DiscoveryClientServerList(discoveryClient, serviceID));
        }
        return serverList;
    }
}

