/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.ribbon.discovery;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import io.micronaut.configuration.ribbon.RibbonLoadBalancer;
import io.micronaut.configuration.ribbon.RibbonServer;
import io.micronaut.configuration.ribbon.discovery.StandardNameClientConfig;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.loadbalance.ServiceInstanceListLoadBalancerFactory;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
@Replaces(value=ServiceInstanceListLoadBalancerFactory.class)
public class RibbonServiceInstanceListLoadBalancerFactory
extends ServiceInstanceListLoadBalancerFactory {
    private final BeanContext beanContext;
    private final IClientConfig defaultClientConfig;
    private final Environment environment;

    public RibbonServiceInstanceListLoadBalancerFactory(BeanContext beanContext, IClientConfig defaultClientConfig, Environment environment) {
        this.beanContext = beanContext;
        this.defaultClientConfig = defaultClientConfig;
        this.environment = environment;
    }

    public LoadBalancer create(ServiceInstanceList serviceInstanceList) {
        String serviceID = serviceInstanceList.getID();
        IClientConfig niwsClientConfig = this.beanContext.findBean(IClientConfig.class, Qualifiers.byName((String)serviceID)).orElse(new StandardNameClientConfig(this.environment, serviceID, this.defaultClientConfig));
        IRule rule = this.beanContext.findBean(IRule.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> (IRule)this.beanContext.createBean(IRule.class));
        IPing ping = this.beanContext.findBean(IPing.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> (IPing)this.beanContext.createBean(IPing.class));
        ServerListFilter serverListFilter = this.beanContext.findBean(ServerListFilter.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> (ServerListFilter)this.beanContext.createBean(ServerListFilter.class));
        ServerList serverList = this.beanContext.findBean(ServerList.class, Qualifiers.byName((String)serviceID)).orElseGet(() -> this.toRibbonServerList(serviceInstanceList));
        if (niwsClientConfig.getPropertyAsBoolean(CommonClientConfigKey.InitializeNFLoadBalancer, true)) {
            return this.createRibbonLoadBalancer(niwsClientConfig, rule, ping, serverListFilter, (ServerList<Server>)serverList);
        }
        return super.create(serviceInstanceList);
    }

    private ServerList toRibbonServerList(final ServiceInstanceList serviceInstanceList) {
        return new AbstractServerList<Server>(){

            public void initWithNiwsConfig(IClientConfig clientConfig) {
            }

            public List<Server> getInitialListOfServers() {
                List instances = serviceInstanceList.getInstances();
                return instances.stream().map(RibbonServer::new).collect(Collectors.toList());
            }

            public List<Server> getUpdatedListOfServers() {
                return this.getInitialListOfServers();
            }
        };
    }

    protected RibbonLoadBalancer createRibbonLoadBalancer(IClientConfig niwsClientConfig, IRule rule, IPing ping, ServerListFilter serverListFilter, ServerList<Server> serverList) {
        return new RibbonLoadBalancer(niwsClientConfig, serverList, serverListFilter, rule, ping);
    }
}

