/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    public static final String MICRONAUT_OPENAPI_ADDITIONAL_FILES = "micronaut.openapi.additional.files";
    private ClassElement classElement;

    public void visitClass(ClassElement element, VisitorContext context) {
        context.info("Generating OpenAPI Documentation");
        Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        OpenAPI openAPI = this.readOpenAPI(element, context);
        if (attr.isPresent()) {
            OpenAPI existing = (OpenAPI)attr.get();
            Optional.ofNullable(openAPI.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
            Optional.ofNullable(openAPI.getTags()).ifPresent(arg_0 -> ((OpenAPI)existing).setTags(arg_0));
            Optional.ofNullable(openAPI.getServers()).ifPresent(arg_0 -> ((OpenAPI)existing).setServers(arg_0));
            Optional.ofNullable(openAPI.getSecurity()).ifPresent(arg_0 -> ((OpenAPI)existing).setSecurity(arg_0));
            Optional.ofNullable(openAPI.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)existing).setExternalDocs(arg_0));
            Optional.ofNullable(openAPI.getExtensions()).ifPresent(arg_0 -> ((OpenAPI)existing).setExtensions(arg_0));
        } else {
            context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openAPI);
        }
        this.mergeAdditionalSwaggerFiles(element, context, openAPI);
        List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation(element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openAPI.getTags());
        openAPI.setTags(tagList);
        List securityRequirements = element.getAnnotationValuesByType(SecurityRequirement.class).stream().map(this::mapToSecurityRequirement).collect(Collectors.toList());
        if (openAPI.getSecurity() != null) {
            securityRequirements.addAll(openAPI.getSecurity());
        }
        openAPI.setSecurity(securityRequirements);
        List<Server> servers = this.processOpenApiAnnotation(element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, openAPI.getServers());
        openAPI.setServers(servers);
        this.processSecuritySchemes(element, context);
        if (Boolean.getBoolean("io.micronaut.OPENAPI_TEST")) {
            testReference = openAPI;
        }
        this.classElement = element;
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        Path directory;
        String additionalSwaggerFiles = System.getProperty(MICRONAUT_OPENAPI_ADDITIONAL_FILES);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles) && Files.isDirectory(directory = Paths.get(additionalSwaggerFiles, new String[0]), new LinkOption[0])) {
            context.info("Merging Swagger OpenAPI YAML files from location :" + additionalSwaggerFiles);
            try {
                Files.newDirectoryStream(directory, path -> path.toString().endsWith(".yml")).forEach(path -> {
                    context.info("Reading Swagger OpenAPI YAML file " + path.getFileName());
                    OpenAPI parsedOpenApi = null;
                    try {
                        parsedOpenApi = (OpenAPI)this.yamlMapper.readValue(path.toFile(), OpenAPI.class);
                    }
                    catch (IOException e) {
                        context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)this.classElement);
                    }
                    if (parsedOpenApi != null) {
                        Optional.ofNullable(parsedOpenApi.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)openAPI).addServersItem(arg_0)));
                        Optional.ofNullable(parsedOpenApi.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)openAPI).path(arg_0, arg_1)));
                        Optional.ofNullable(parsedOpenApi.getComponents()).ifPresent(components -> {
                            Map securitySchemes;
                            Map schemas = components.getSchemas();
                            if (schemas != null && !schemas.isEmpty()) {
                                schemas.forEach((arg_0, arg_1) -> ((OpenAPI)openAPI).schema(arg_0, arg_1));
                            }
                            if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                                securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)openAPI).schemaRequirement(arg_0, arg_1));
                            }
                        });
                        Optional.ofNullable(parsedOpenApi.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)openAPI).addSecurityItem(arg_0)));
                        Optional.ofNullable(parsedOpenApi.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)openAPI).addTagsItem(arg_0)));
                        Optional.ofNullable(parsedOpenApi.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)openAPI).addExtension(arg_0, arg_1)));
                    }
                });
            }
            catch (IOException e) {
                context.warn("Unable to read  file from " + directory.getFileName() + ": " + e.getMessage(), (Element)this.classElement);
            }
        }
    }

    private <T, A extends Annotation> List<T> processOpenApiAnnotation(ClassElement element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                JsonNode jsonNode = this.toJson(tag.getValues(), context);
                try {
                    Object t = this.jsonMapper.treeToValue((TreeNode)jsonNode, modelType);
                    if (t == null) continue;
                    tagList.add(t);
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading OpenAPI" + annotationType + " annotation", (Element)element);
                }
            }
        }
        return tagList;
    }

    private OpenAPI readOpenAPI(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            JsonNode jsonNode = this.toJson(o.getValues(), context);
            try {
                Optional<Object> result = Optional.of(this.jsonMapper.treeToValue((TreeNode)jsonNode, OpenAPI.class));
                result.ifPresent(openAPI -> {
                    List securityRequirements = o.getAnnotations("security", SecurityRequirement.class).stream().map(this::mapToSecurityRequirement).collect(Collectors.toList());
                    openAPI.setSecurity(securityRequirements);
                });
                return result;
            }
            catch (JsonProcessingException e) {
                context.warn("Error reading Swagger OpenAPI for element [" + element + "]: " + e.getMessage(), (Element)element);
                return Optional.empty();
            }
        }).orElse(new OpenAPI());
    }

    public void finish(VisitorContext visitorContext) {
        if (this.classElement != null) {
            Optional attr = visitorContext.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            attr.ifPresent(openAPI -> {
                String property = System.getProperty(MICRONAUT_OPENAPI_TARGET_FILE);
                if (StringUtils.isNotEmpty((CharSequence)property)) {
                    File f = new File(property);
                    visitorContext.info("Writing OpenAPI YAML to destination: " + f);
                    try {
                        f.getParentFile().mkdirs();
                        this.yamlMapper.writeValue(f, openAPI);
                    }
                    catch (Exception e) {
                        visitorContext.warn("Unable to generate swagger.yml: " + e.getMessage(), (Element)this.classElement);
                    }
                } else {
                    Optional generatedFile;
                    String fileName = "swagger.yml";
                    Info info = openAPI.getInfo();
                    if (info != null) {
                        String title = Optional.ofNullable(info.getTitle()).orElse("application");
                        title = title.toLowerCase().replace(' ', '-');
                        String version = info.getVersion();
                        if (version != null) {
                            fileName = title + "-" + version + ".yml";
                        }
                    }
                    if ((generatedFile = visitorContext.visitMetaInfFile("swagger/" + fileName)).isPresent()) {
                        GeneratedFile f = (GeneratedFile)generatedFile.get();
                        try {
                            visitorContext.info("Writing OpenAPI YAML to destination: " + f.toURI());
                            Writer writer = f.openWriter();
                            this.yamlMapper.writeValue(writer, openAPI);
                        }
                        catch (Exception e) {
                            visitorContext.warn("Unable to generate swagger.yml: " + e.getMessage(), (Element)this.classElement);
                        }
                    }
                }
            });
        }
    }
}

