/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.javadoc;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.openapi.javadoc.JavadocDescription;
import java.util.Set;

public class JavadocParser {
    private static final Set<String> IGNORED = CollectionUtils.setOf((Object[])new String[]{"see", "since", "author", "version", "deprecated", "throws"});
    private static final int TEXT = 1;
    private static final int TAG_START = 2;
    private static final int DOCLET_START = 4;
    private static final int PARAM_NAME = 6;
    private static final int PARAM_DESC = 7;
    private static final int RETURN_DESC = 8;
    private static final int IGNORE = 9;
    private int previousState = 1;

    public JavadocDescription parse(String text) {
        StringBuilder description = new StringBuilder();
        int state = 1;
        JavadocDescription javadocDescription = new JavadocDescription();
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            char[] chars = text.toCharArray();
            StringBuilder currentParam = new StringBuilder();
            StringBuilder currentDoclet = new StringBuilder();
            StringBuilder currentDescription = description;
            block9: for (char c : chars) {
                switch (state) {
                    case 8: {
                        javadocDescription.setReturnDescription(currentDescription.toString().trim());
                    }
                    case 7: {
                        if (state == 7) {
                            javadocDescription.getParameters().put(currentParam.toString(), currentDescription.toString().trim());
                        }
                    }
                    case 1: {
                        if (c == '{' || c == '@') {
                            currentDoclet.delete(0, currentDoclet.length());
                            state = 4;
                            continue block9;
                        }
                        if (c == '<') {
                            state = 2;
                            continue block9;
                        }
                        if (c == '}' || c == '>') continue block9;
                        currentDescription.append(c);
                        continue block9;
                    }
                    case 9: {
                        if (c != '\n') continue block9;
                        state = this.previousState;
                        currentDescription = description;
                        continue block9;
                    }
                    case 4: {
                        if (c == ' ') {
                            state = this.previousState;
                            String docletName = currentDoclet.toString();
                            if (IGNORED.contains(docletName)) {
                                state = 9;
                                continue block9;
                            }
                            if (docletName.equals("param")) {
                                currentParam.delete(0, currentParam.length());
                                state = 6;
                            }
                            if (!docletName.equals("return")) continue block9;
                            currentDescription = new StringBuilder();
                            state = 8;
                            this.previousState = 8;
                            continue block9;
                        }
                        currentDoclet.append(c);
                        continue block9;
                    }
                    case 6: {
                        if (c == ' ') {
                            currentDescription = new StringBuilder();
                            state = 7;
                            this.previousState = 7;
                            continue block9;
                        }
                        currentParam.append(c);
                        continue block9;
                    }
                    case 2: {
                        if (c != '>') continue block9;
                        state = 1;
                    }
                }
            }
        }
        javadocDescription.setMethodDescription(description.toString().trim());
        return javadocDescription;
    }
}

