/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.inject.visitor.VisitorContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public final class OpenApiViewConfig {
    private String mappingPath;
    private String title;
    private String specFile;
    private SwaggerUIConfig swaggerUIConfig;
    private RedocConfig redocConfig;
    private RapidocConfig rapidocConfig;

    private OpenApiViewConfig() {
    }

    private static Map<String, String> parse(String specification) {
        if (specification == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(specification.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> s.split("=")).filter(keyValue -> ((String[])keyValue).length == 2).peek(keyValue -> {
            keyValue[0] = keyValue[0].trim().toLowerCase(Locale.US);
            keyValue[1] = keyValue[1].trim();
        }).filter(keyValue -> !keyValue[0].isEmpty() && !keyValue[1].isEmpty()).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
    }

    public static OpenApiViewConfig fromSpecification(String specification) {
        Map<String, String> properties = OpenApiViewConfig.parse(specification);
        OpenApiViewConfig cfg = new OpenApiViewConfig();
        if ("true".equals(properties.getOrDefault("redoc.enabled", Boolean.FALSE.toString()))) {
            cfg.redocConfig = RedocConfig.fromProperties(properties);
        }
        if ("true".equals(properties.getOrDefault("rapidoc.enabled", Boolean.FALSE.toString()))) {
            cfg.rapidocConfig = RapidocConfig.fromProperties(properties);
        }
        if ("true".equals(properties.getOrDefault("swagger-ui.enabled", Boolean.FALSE.toString()))) {
            cfg.swaggerUIConfig = SwaggerUIConfig.fromProperties(properties);
        }
        cfg.mappingPath = properties.getOrDefault("mapping.path", "swagger");
        return cfg;
    }

    public boolean isEnabled() {
        return this.redocConfig != null || this.rapidocConfig != null || this.swaggerUIConfig != null;
    }

    public void render(Path outputDir, VisitorContext visitorContext) throws IOException {
        if (this.redocConfig != null) {
            this.render(this.redocConfig, outputDir.resolve("redoc"), "templates/redoc/index.html", visitorContext);
        }
        if (this.rapidocConfig != null) {
            this.render(this.rapidocConfig, outputDir.resolve("rapidoc"), "templates/rapidoc/index.html", visitorContext);
        }
        if (this.swaggerUIConfig != null) {
            this.render(this.swaggerUIConfig, outputDir.resolve("swagger-ui"), "templates/swagger-ui/index.html", visitorContext);
        }
    }

    /*
     * Exception decompiling
     */
    private String readTemplateFromClasspath(String templateName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void render(Renderer renderer, Path outputDir, String templateName, VisitorContext visitorContext) throws IOException {
        String template = this.readTemplateFromClasspath(templateName);
        template = OpenApiViewConfig.replacePlaceHolder(template, "specURL", this.getSpecURL(), "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "title", this.getTitle(), "");
        template = renderer.render(template);
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        Path file = outputDir.resolve("index.html");
        if (visitorContext != null) {
            visitorContext.info("Writing OpenAPI View to destination: " + file);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(template);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSpecURL() {
        return '/' + this.mappingPath + '/' + this.specFile;
    }

    public void setSpecFile(String specFile) {
        this.specFile = specFile;
    }

    public RapidocConfig getRapidoc() {
        return this.rapidocConfig;
    }

    public RedocConfig getRedoc() {
        return this.redocConfig;
    }

    public SwaggerUIConfig getSwaggerUi() {
        return this.swaggerUIConfig;
    }

    public String toString() {
        return new StringBuilder(100).append("OpenApiConfig [swaggerUIConfig=").append(this.swaggerUIConfig).append(", reDocConfig=").append(this.redocConfig).append(", rapiDocConfig=").append(this.rapidocConfig).append(']').toString();
    }

    private static String replacePlaceHolder(String template, String placeHolder, String value, String valuePrefix) {
        if (value != null && !value.isEmpty()) {
            return template.replace("{{" + placeHolder + "}}", valuePrefix + value);
        }
        return template.replace("{{" + placeHolder + "}}", "");
    }

    public static final class SwaggerUIConfig
    implements Renderer {
        private String version = "";
        private String layout = "StandaloneLayout";
        private boolean deepLinking = true;
        private Theme theme = Theme.DEFAULT;

        private SwaggerUIConfig() {
        }

        static SwaggerUIConfig fromProperties(Map<String, String> properties) {
            SwaggerUIConfig cfg = new SwaggerUIConfig();
            cfg.version = properties.getOrDefault("swagger-ui.version", cfg.version);
            cfg.layout = properties.getOrDefault("swagger-ui.layout", cfg.layout);
            cfg.deepLinking = Boolean.valueOf(properties.getOrDefault("swagger-ui.deep-linking", Boolean.toString(cfg.deepLinking)));
            cfg.theme = Theme.valueOf(properties.getOrDefault("swagger-ui.theme", cfg.theme.name()).toUpperCase(Locale.US));
            return cfg;
        }

        @Override
        public String render(String template) {
            template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.version", this.version, "@");
            template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.layout", this.getLayout(), "");
            template = this.getTheme() != null && !Theme.DEFAULT.equals((Object)this.getTheme()) ? template.replace("{{swagger-ui.theme}}", "<link rel='stylesheet' type='text/css' href='https://unpkg.com/swagger-ui-themes@3.0.0/themes/3.x/" + this.getTheme().css + ".css' />") : template.replace("{{swagger-ui.theme}}", "");
            template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.deep-linking", Boolean.toString(this.deepLinking), "");
            return template;
        }

        public String getVersion() {
            return this.version;
        }

        public String getLayout() {
            return this.layout;
        }

        public boolean isDeepLinking() {
            return this.deepLinking;
        }

        public Theme getTheme() {
            return this.theme;
        }

        public String toString() {
            return new StringBuilder(100).append("[version=").append(this.version).append(", layout=").append(this.layout).append(", theme=").append((Object)this.theme).append(", deepLinking=").append(this.deepLinking).append(']').toString();
        }

        static enum Theme {
            DEFAULT(null),
            MATERIAL("theme-material"),
            FEELING_BLUE("theme-feeling-blue"),
            FLATTOP("theme-flattop"),
            MONOKAI("theme-monokai"),
            MUTED("theme-muted"),
            NEWSPAPER("theme-newspaper"),
            OUTLINE("theme-outline");

            private String css;

            private Theme(String css) {
                this.css = css;
            }

            public String getCss() {
                return this.css;
            }
        }
    }

    public static final class RedocConfig
    implements Renderer {
        private String version = "";

        private RedocConfig() {
        }

        static RedocConfig fromProperties(Map<String, String> properties) {
            RedocConfig cfg = new RedocConfig();
            cfg.version = properties.getOrDefault("redoc.version", cfg.version);
            return cfg;
        }

        @Override
        public String render(String template) {
            return OpenApiViewConfig.replacePlaceHolder(template, "redoc.version", this.version, "@");
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return new StringBuilder(30).append("[version=").append(this.version).append(']').toString();
        }
    }

    public static final class RapidocConfig
    implements Renderer {
        private String version = "";
        private Theme theme = Theme.DARK;
        private Layout layout = Layout.ROW;

        private RapidocConfig() {
        }

        static RapidocConfig fromProperties(Map<String, String> properties) {
            RapidocConfig cfg = new RapidocConfig();
            cfg.version = properties.getOrDefault("rapidoc.version", cfg.version);
            cfg.layout = Layout.valueOf(properties.getOrDefault("rapidoc.layout", cfg.layout.name()).toUpperCase(Locale.US));
            cfg.theme = Theme.valueOf(properties.getOrDefault("rapidoc.theme", cfg.theme.name()).toUpperCase(Locale.US));
            return cfg;
        }

        @Override
        public String render(String template) {
            template = OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.version", this.version, "@");
            template = OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.layout", this.getLayout().toString(), "");
            template = OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.theme", this.getTheme().toString(), "");
            return template;
        }

        public Theme getTheme() {
            return this.theme;
        }

        public Layout getLayout() {
            return this.layout;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return new StringBuilder(50).append("RapidocConfig [version=").append(this.version).append(", theme=").append((Object)this.theme).append(", layout=").append((Object)this.layout).append(']').toString();
        }

        static enum Layout {
            COLUMN,
            ROW;


            public String toString() {
                return this.name().toLowerCase(Locale.US);
            }
        }

        static enum Theme {
            LIGHT,
            DARK;


            public String toString() {
                return this.name().toLowerCase(Locale.US);
            }
        }
    }

    private static interface Renderer {
        public String render(String var1);
    }
}

