/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY = "micronaut.openapi.property.naming.strategy";
    public static final String MICRONAUT_OPENAPI_VIEWS_SPEC = "micronaut.openapi.views.spec";
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    public static final String MICRONAUT_OPENAPI_ADDITIONAL_FILES = "micronaut.openapi.additional.files";
    private ClassElement classElement;
    private Path projectDirectory;

    public void visitClass(ClassElement element, VisitorContext context) {
        context.info("Generating OpenAPI Documentation");
        OpenAPI openAPI = this.readOpenAPI(element, context);
        this.mergeAdditionalSwaggerFiles(element, context, openAPI);
        List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation(element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openAPI.getTags());
        openAPI.setTags(tagList);
        List securityRequirements = element.getAnnotationValuesByType(SecurityRequirement.class).stream().map(this::mapToSecurityRequirement).collect(Collectors.toList());
        if (openAPI.getSecurity() != null) {
            securityRequirements.addAll(openAPI.getSecurity());
        }
        openAPI.setSecurity(securityRequirements);
        List<io.swagger.v3.oas.models.servers.Server> servers = this.processOpenApiAnnotation(element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, openAPI.getServers());
        openAPI.setServers(servers);
        this.processSecuritySchemes(element, context);
        Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        if (attr.isPresent()) {
            OpenAPI existing = (OpenAPI)attr.get();
            Optional.ofNullable(openAPI.getInfo()).ifPresent(arg_0 -> ((OpenAPI)existing).setInfo(arg_0));
            this.copyOpenAPI(existing, openAPI);
        } else {
            context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openAPI);
        }
        if (Boolean.getBoolean("io.micronaut.OPENAPI_TEST")) {
            testReference = this.resolveOpenAPI(context);
        }
        this.classElement = element;
    }

    private void mergeAdditionalSwaggerFiles(ClassElement element, VisitorContext context, OpenAPI openAPI) {
        String additionalSwaggerFiles = System.getProperty(MICRONAUT_OPENAPI_ADDITIONAL_FILES);
        if (StringUtils.isNotEmpty((CharSequence)additionalSwaggerFiles)) {
            Path directory = this.resolve(context, Paths.get(additionalSwaggerFiles, new String[0]));
            if (Files.isDirectory(directory, new LinkOption[0])) {
                context.info("Merging Swagger OpenAPI YAML files from location :" + directory);
                try {
                    Files.newDirectoryStream(directory, path -> path.toString().endsWith(".yml")).forEach(path -> {
                        context.info("Reading Swagger OpenAPI YAML file " + path.getFileName());
                        OpenAPI parsedOpenApi = null;
                        try {
                            parsedOpenApi = (OpenAPI)this.yamlMapper.readValue(path.toFile(), OpenAPI.class);
                        }
                        catch (IOException e) {
                            context.warn("Unable to read file " + path.getFileName() + ": " + e.getMessage(), (Element)this.classElement);
                        }
                        this.copyOpenAPI(openAPI, parsedOpenApi);
                    });
                }
                catch (IOException e) {
                    context.warn("Unable to read  file from " + directory + ": " + e.getMessage(), (Element)this.classElement);
                }
            } else {
                context.warn(directory + " does not exist or is not a directory", (Element)this.classElement);
            }
        }
    }

    private Path resolve(VisitorContext context, Path directory) {
        Path projectDir;
        if (!directory.isAbsolute() && (projectDir = this.projectDir(context)) != null) {
            directory = projectDir.resolve(directory);
        }
        return directory;
    }

    private void copyOpenAPI(OpenAPI to, OpenAPI from) {
        if (to != null && from != null) {
            Optional.ofNullable(from.getTags()).ifPresent(tags -> tags.forEach(arg_0 -> ((OpenAPI)to).addTagsItem(arg_0)));
            Optional.ofNullable(from.getServers()).ifPresent(servers -> servers.forEach(arg_0 -> ((OpenAPI)to).addServersItem(arg_0)));
            Optional.ofNullable(from.getSecurity()).ifPresent(securityRequirements -> securityRequirements.forEach(arg_0 -> ((OpenAPI)to).addSecurityItem(arg_0)));
            Optional.ofNullable(from.getPaths()).ifPresent(paths -> paths.forEach((arg_0, arg_1) -> ((OpenAPI)to).path(arg_0, arg_1)));
            Optional.ofNullable(from.getComponents()).ifPresent(components -> {
                Map securitySchemes;
                Map schemas = components.getSchemas();
                if (schemas != null && !schemas.isEmpty()) {
                    schemas.forEach((arg_0, arg_1) -> ((OpenAPI)to).schema(arg_0, arg_1));
                }
                if ((securitySchemes = components.getSecuritySchemes()) != null && !securitySchemes.isEmpty()) {
                    securitySchemes.forEach((arg_0, arg_1) -> ((OpenAPI)to).schemaRequirement(arg_0, arg_1));
                }
            });
            Optional.ofNullable(from.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)to).externalDocs(arg_0));
            Optional.ofNullable(from.getExtensions()).ifPresent(extensions -> extensions.forEach((arg_0, arg_1) -> ((OpenAPI)to).addExtension(arg_0, arg_1)));
        }
    }

    private <T, A extends Annotation> List<T> processOpenApiAnnotation(ClassElement element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                JsonNode jsonNode;
                if (tag.getAnnotationName().equals(SecurityRequirement.class.getName()) && tag.getValues().size() > 0) {
                    Object name = tag.getValues().get("name");
                    ArrayList scopes = Optional.ofNullable(tag.getValues().get("scopes")).orElse(new ArrayList());
                    jsonNode = this.toJson(Collections.singletonMap((CharSequence)name, scopes), context);
                } else {
                    jsonNode = this.toJson(tag.getValues(), context);
                }
                try {
                    T t = this.treeToValue(jsonNode, modelType);
                    if (t == null) continue;
                    tagList.add(t);
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading OpenAPI" + annotationType + " annotation", (Element)element);
                }
            }
        }
        return tagList;
    }

    private OpenAPI readOpenAPI(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            JsonNode jsonNode = this.toJson(o.getValues(), context);
            try {
                Optional<OpenAPI> result = Optional.of(this.treeToValue(jsonNode, OpenAPI.class));
                result.ifPresent(openAPI -> {
                    List securityRequirements = o.getAnnotations("security", SecurityRequirement.class).stream().map(this::mapToSecurityRequirement).collect(Collectors.toList());
                    openAPI.setSecurity(securityRequirements);
                });
                return result;
            }
            catch (JsonProcessingException e) {
                context.warn("Error reading Swagger OpenAPI for element [" + element + "]: " + e.getMessage(), (Element)element);
                return Optional.empty();
            }
        }).orElse(new OpenAPI());
    }

    private void renderViews(String title, String specFile, Path destinationDir, VisitorContext visitorContext) throws IOException {
        OpenApiViewConfig cfg;
        String viewSpecification = System.getProperty(MICRONAUT_OPENAPI_VIEWS_SPEC);
        if (viewSpecification != null && (cfg = OpenApiViewConfig.fromSpecification(viewSpecification)).isEnabled()) {
            cfg.setTitle(title);
            cfg.setSpecFile(specFile);
            cfg.render(destinationDir.resolve("views"), visitorContext);
        }
    }

    private static PropertyNamingStrategy.PropertyNamingStrategyBase fromName(String name) {
        if (name == null) {
            return null;
        }
        switch (name.toUpperCase()) {
            case "SNAKE_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.SNAKE_CASE;
            }
            case "UPPER_CAMEL_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.UPPER_CAMEL_CASE;
            }
            case "LOWER_CAMEL_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.LOWER_CAMEL_CASE;
            }
            case "LOWER_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.LOWER_CASE;
            }
            case "KEBAB_CASE": {
                return (PropertyNamingStrategy.PropertyNamingStrategyBase)PropertyNamingStrategy.KEBAB_CASE;
            }
        }
        return null;
    }

    private Optional<Path> openApiSpecFile(String fileName, VisitorContext visitorContext) {
        URI uri;
        Optional<Path> path = this.userDefinedSpecFile(visitorContext);
        if (path.isPresent()) {
            return path;
        }
        Optional generatedFile = visitorContext.visitMetaInfFile("swagger/" + fileName);
        if (generatedFile.isPresent() && (uri = ((GeneratedFile)generatedFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            Path specPath = Paths.get(uri);
            OpenApiApplicationVisitor.createDirectories(specPath, visitorContext);
            return Optional.of(specPath);
        }
        visitorContext.warn("Unable to get swagger/" + fileName + " file.", null);
        return Optional.empty();
    }

    private Path projectDir(VisitorContext visitorContext) {
        URI uri;
        if (this.projectDirectory != null) {
            return this.projectDirectory;
        }
        Optional dummyFile = visitorContext.visitGeneratedFile("dummy");
        if (dummyFile.isPresent() && (uri = ((GeneratedFile)dummyFile.get()).toURI()).getScheme() != null && !uri.getScheme().equals("mem")) {
            for (Path dummy = Paths.get(uri).normalize(); dummy != null; dummy = dummy.getParent()) {
                Path dummyFileName = dummy.getFileName();
                if (dummyFileName == null || !"build".equals(dummyFileName.toString())) continue;
                this.projectDirectory = dummy.getParent();
                break;
            }
        }
        return this.projectDirectory;
    }

    private Optional<Path> userDefinedSpecFile(VisitorContext visitorContext) {
        String targetFile = System.getProperty(MICRONAUT_OPENAPI_TARGET_FILE);
        if (StringUtils.isEmpty((CharSequence)targetFile)) {
            return Optional.empty();
        }
        Path specFile = this.resolve(visitorContext, Paths.get(targetFile, new String[0]));
        OpenApiApplicationVisitor.createDirectories(specFile, visitorContext);
        return Optional.of(specFile);
    }

    private static void createDirectories(Path f, VisitorContext visitorContext) {
        if (f.getParent() != null) {
            try {
                Files.createDirectories(f.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                visitorContext.warn("Fail to create directories for" + f + ": " + e.getMessage(), null);
            }
        }
    }

    public void finish(VisitorContext visitorContext) {
        if (this.classElement == null) {
            return;
        }
        Optional attr = visitorContext.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        attr.ifPresent(openAPI -> {
            Optional<Path> specFile;
            String namingStrategyName = System.getProperty(MICRONAUT_OPENAPI_PROPERTY_NAMING_STRATEGY);
            PropertyNamingStrategy.PropertyNamingStrategyBase propertyNamingStrategy = OpenApiApplicationVisitor.fromName(namingStrategyName);
            if (propertyNamingStrategy != null) {
                visitorContext.info("Using " + namingStrategyName + " property naming strategy.");
                openAPI.getComponents().getSchemas().values().forEach(model -> {
                    Map properties = model.getProperties();
                    if (properties == null) {
                        return;
                    }
                    Map newProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> propertyNamingStrategy.translate((String)entry.getKey()), Map.Entry::getValue, (prop1, prop2) -> prop1, LinkedHashMap::new));
                    model.getProperties().clear();
                    model.setProperties(newProperties);
                });
            }
            String fileName = "swagger.yml";
            String documentTitle = "OpenAPI";
            Info info = openAPI.getInfo();
            if (info != null) {
                documentTitle = Optional.ofNullable(info.getTitle()).orElse("application");
                documentTitle = documentTitle.toLowerCase().replace(' ', '-');
                String version = info.getVersion();
                if (version != null) {
                    documentTitle = documentTitle + '-' + version;
                }
                fileName = documentTitle + ".yml";
            }
            if ((specFile = this.openApiSpecFile(fileName, visitorContext)).isPresent()) {
                Path specPath = specFile.get();
                try (BufferedWriter writer = Files.newBufferedWriter(specPath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                    visitorContext.info("Writing OpenAPI YAML to destination: " + specPath);
                    this.yamlMapper.writeValue((Writer)writer, openAPI);
                    this.renderViews(documentTitle, fileName, specPath.getParent(), visitorContext);
                }
                catch (Exception e) {
                    visitorContext.warn("Unable to generate swagger.yml: " + specPath + " - " + e.getMessage(), (Element)this.classElement);
                }
            }
        });
    }
}

