/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.Renderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

final class RapidocConfig
extends AbstractViewConfig
implements Renderer {
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>();
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(45);
    RapiPDFConfig rapiPDFConfig;

    private RapidocConfig() {
        super("rapidoc.");
    }

    static RapidocConfig fromProperties(Map<String, String> properties) {
        return AbstractViewConfig.fromProperties(new RapidocConfig(), DEFAULT_OPTIONS, properties);
    }

    @Override
    public String render(String template) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.RAPIDOC);
        template = OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.version", this.version, "@");
        return OpenApiViewConfig.replacePlaceHolder(template, "rapidoc.attributes", this.toHtmlAttributes(), "");
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    static {
        VALID_OPTIONS.put("style", AbstractViewConfig::asString);
        VALID_OPTIONS.put("sort-tags", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("sort-endpoints-by", new AbstractViewConfig.EnumConverter<EndPoint>(EndPoint.class));
        VALID_OPTIONS.put("heading-text", AbstractViewConfig::asString);
        VALID_OPTIONS.put("goto-path", AbstractViewConfig::asString);
        VALID_OPTIONS.put("theme", new AbstractViewConfig.EnumConverter<Theme>(Theme.class));
        VALID_OPTIONS.put("bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("header-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("primary-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("regular-font", AbstractViewConfig::asString);
        VALID_OPTIONS.put("mono-font", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-hover-bg-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-hover-text-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("nav-accent-color", AbstractViewConfig::asString);
        VALID_OPTIONS.put("layout", new AbstractViewConfig.EnumConverter<Layout>(Layout.class));
        VALID_OPTIONS.put("render-style", new AbstractViewConfig.EnumConverter<RenderStyle>(RenderStyle.class));
        VALID_OPTIONS.put("schema-style", new AbstractViewConfig.EnumConverter<SchemaStyle>(SchemaStyle.class));
        VALID_OPTIONS.put("schema-expand-level", AbstractViewConfig::asString);
        VALID_OPTIONS.put("schema-description-expanded", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("default-schema-tab", new AbstractViewConfig.EnumConverter<DefaultSchemaTab>(DefaultSchemaTab.class));
        VALID_OPTIONS.put("response-area-height", AbstractViewConfig::asString);
        VALID_OPTIONS.put("show-info", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("show-header", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-authentication", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-spec-url-load", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-spec-file-load", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-search", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-try", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("allow-server-selection", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("api-key-name", AbstractViewConfig::asString);
        VALID_OPTIONS.put("api-key-value", AbstractViewConfig::asString);
        VALID_OPTIONS.put("api-key-location", new AbstractViewConfig.EnumConverter<ApiKeyLocation>(ApiKeyLocation.class));
        VALID_OPTIONS.put("server-url", AbstractViewConfig::asString);
        VALID_OPTIONS.put("default-api-server", AbstractViewConfig::asString);
        VALID_OPTIONS.put("match-paths", AbstractViewConfig::asString);
        DEFAULT_OPTIONS.put("show-header", Boolean.FALSE);
        DEFAULT_OPTIONS.put("theme", (Object)Theme.DARK);
        DEFAULT_OPTIONS.put("layout", (Object)Layout.ROW);
        DEFAULT_OPTIONS.put("sort-tags", Boolean.TRUE);
        DEFAULT_OPTIONS.put("sort-endpoints-by", (Object)EndPoint.METHOD);
    }

    static enum Layout {
        COLUMN,
        ROW;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum Theme {
        LIGHT,
        DARK;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum EndPoint {
        PATH,
        METHOD;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum RenderStyle {
        READ,
        VIEW;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum SchemaStyle {
        TREE,
        TABLE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum DefaultSchemaTab {
        MODEL,
        EXAMPLE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    static enum ApiKeyLocation {
        HEADER,
        QUERY;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

