/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.DefaultConversionService;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenApiControllerVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<Controller, HttpMethodMapping> {
    private static final String CLASS_TAGS = "CLASS_TAGS";
    private PropertyPlaceholderResolver propertyPlaceholderResolver;

    public void visitClass(ClassElement element, VisitorContext context) {
        this.processSecuritySchemes(element, context);
        context.put((CharSequence)CLASS_TAGS, this.readTags(element, context));
    }

    private boolean hasNoBindingAnnotationOrType(ParameterElement parameter) {
        return !parameter.isAnnotationPresent(Parameter.class) && !parameter.isAnnotationPresent(io.swagger.v3.oas.annotations.parameters.RequestBody.class) && !parameter.isAnnotationPresent(Hidden.class) && !parameter.isAnnotationPresent(QueryValue.class) && !parameter.isAnnotationPresent(PathVariable.class) && !parameter.isAnnotationPresent(Body.class) && !parameter.isAnnotationPresent(Part.class) && !parameter.isAnnotationPresent(CookieValue.class) && !parameter.isAnnotationPresent(Header.class) && !this.isIgnoredParameterType(parameter.getType()) && !this.isResponseType(parameter.getType()) && !parameter.getType().isAssignable(HttpRequest.class) && !parameter.getType().isAssignable("io.micronaut.http.BasicAuth");
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (element.isAnnotationPresent(Hidden.class)) {
            return;
        }
        Optional httpMethodOpt = element.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        httpMethodOpt.ifPresent(httpMethodClass -> {
            List bodyParameters;
            boolean hasExistingParameters;
            boolean permitsRequestBody;
            HttpMethod httpMethod = null;
            try {
                httpMethod = HttpMethod.valueOf((String)httpMethodClass.getSimpleName().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (httpMethod == null) {
                return;
            }
            String controllerValue = element.getDeclaringType().getValue(UriMapping.class, String.class).orElse("/");
            controllerValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(controllerValue).orElse(controllerValue);
            UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)controllerValue);
            String methodValue = element.getValue(HttpMethodMapping.class, String.class).orElse("/");
            methodValue = this.getPropertyPlaceholderResolver().resolvePlaceholders(methodValue).orElse(methodValue);
            matchTemplate = matchTemplate.nest((CharSequence)methodValue);
            PathItem pathItem = this.resolvePathItem(context, matchTemplate);
            OpenAPI openAPI = this.resolveOpenAPI(context);
            Optional operationAnnotation = element.findAnnotation(io.swagger.v3.oas.annotations.Operation.class);
            Operation swaggerOperation = operationAnnotation.flatMap(o -> this.toValue(o.getValues(), context, Operation.class)).orElse(new Operation());
            this.readTags(element, swaggerOperation, (List)context.get((CharSequence)CLASS_TAGS, List.class, Collections.emptyList()));
            for (SecurityRequirement securityItem : this.readSecurityRequirements((Element)element)) {
                swaggerOperation.addSecurityItem(securityItem);
            }
            this.readApiResponses(element, context, swaggerOperation);
            this.readServers(element, context, swaggerOperation);
            this.readCallbacks(element, context, swaggerOperation);
            JavadocDescription javadocDescription = element.getDocumentation().map(s -> new JavadocParser().parse((String)s)).orElse(null);
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
                swaggerOperation.setDescription(javadocDescription.getMethodDescription());
                swaggerOperation.setSummary(javadocDescription.getMethodDescription());
            }
            this.setOperationOnPathItem(pathItem, swaggerOperation, httpMethod);
            if (element.isAnnotationPresent(Deprecated.class)) {
                swaggerOperation.setDeprecated(Boolean.valueOf(true));
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getOperationId())) {
                swaggerOperation.setOperationId(element.getName());
            }
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters = swaggerOperation.getParameters();
            List pv = matchTemplate.getVariables();
            LinkedHashMap<String, UriMatchVariable> pathVariables = new LinkedHashMap<String, UriMatchVariable>(pv.size());
            for (UriMatchVariable variable : pv) {
                pathVariables.put(variable.getName(), variable);
            }
            OptionalValues consumesMediaTypes = element.getValues(Consumes.class, List.class);
            String consumesMediaType = element.stringValue(Consumes.class).orElse("application/json");
            ApiResponses responses = swaggerOperation.getResponses();
            if (responses == null) {
                responses = new ApiResponses();
                swaggerOperation.setResponses(responses);
                ApiResponse okResponse = new ApiResponse();
                if (javadocDescription == null) {
                    okResponse.setDescription(swaggerOperation.getOperationId() + " default response");
                } else {
                    okResponse.setDescription(javadocDescription.getReturnDescription());
                }
                ClassElement returnType = element.getReturnType();
                if (returnType.isAssignable("io.reactivex.Completable")) {
                    returnType = null;
                } else if (this.isResponseType(returnType)) {
                    returnType = returnType.getFirstTypeArgument().orElse(returnType);
                } else if (this.isSingleResponseType(returnType)) {
                    returnType = (ClassElement)returnType.getFirstTypeArgument().get();
                    returnType = returnType.getFirstTypeArgument().orElse(returnType);
                }
                if (returnType != null) {
                    OptionalValues mediaTypes = element.getValues(Produces.class, List.class);
                    Content content = mediaTypes.isEmpty() ? this.buildContent((Element)element, returnType, "application/json", openAPI, context) : this.buildContent((Element)element, returnType, (OptionalValues<List>)mediaTypes, openAPI, context);
                    okResponse.setContent(content);
                }
                responses.put((Object)"default", (Object)okResponse);
            }
            if (permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
                this.readSwaggerRequestBody((Element)element, context, swaggerOperation);
            }
            if (!(hasExistingParameters = CollectionUtils.isNotEmpty((Collection)swaggerParameters))) {
                swaggerParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
                swaggerOperation.setParameters(swaggerParameters);
            }
            for (ParameterElement parameter : element.getParameters()) {
                AnnotationValue paramAnn;
                CharSequence desc;
                ClassElement parameterType = parameter.getType();
                String parameterName = parameter.getName();
                if (this.isIgnoredParameterType(parameterType)) continue;
                if (permitsRequestBody && swaggerOperation.getRequestBody() == null) {
                    this.readSwaggerRequestBody((Element)parameter, context, swaggerOperation);
                }
                if (parameter.isAnnotationPresent(Body.class)) {
                    if (!permitsRequestBody) continue;
                    RequestBody requestBody = swaggerOperation.getRequestBody();
                    if (requestBody == null) {
                        requestBody = new RequestBody();
                        swaggerOperation.setRequestBody(requestBody);
                    }
                    if (requestBody.getDescription() == null && javadocDescription != null && (desc = javadocDescription.getParameters().get(parameterName)) != null) {
                        requestBody.setDescription(desc.toString());
                    }
                    if (requestBody.getRequired() == null) {
                        requestBody.setRequired(Boolean.valueOf(!parameter.isAnnotationPresent(Nullable.class) && !parameterType.isAssignable(Optional.class)));
                    }
                    if (requestBody.getContent() != null) continue;
                    Content content = consumesMediaTypes.isEmpty() ? this.buildContent((Element)parameter, parameterType, "application/json", openAPI, context) : this.buildContent((Element)parameter, parameterType, (OptionalValues<List>)consumesMediaTypes, openAPI, context);
                    requestBody.setContent(content);
                    continue;
                }
                if (hasExistingParameters) continue;
                io.swagger.v3.oas.models.parameters.Parameter newParameter = null;
                if (!parameter.hasStereotype(Bindable.class) && pathVariables.containsKey(parameterName)) {
                    UriMatchVariable var = (UriMatchVariable)pathVariables.get(parameterName);
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(var.isQuery() ? ParameterIn.QUERY.toString() : ParameterIn.PATH.toString());
                    boolean exploded = var.isExploded();
                    if (exploded) {
                        newParameter.setExplode(Boolean.valueOf(exploded));
                    }
                } else if (parameter.isAnnotationPresent(PathVariable.class)) {
                    String paramName = parameter.getValue(PathVariable.class, String.class).orElse(parameterName);
                    UriMatchVariable var = (UriMatchVariable)pathVariables.get(paramName);
                    if (var == null) {
                        context.fail("Path variable name: '" + paramName + "' not found in path.", (Element)parameter);
                        continue;
                    }
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.PATH.toString());
                    newParameter.setName(paramName);
                    boolean exploded = var.isExploded();
                    if (exploded) {
                        newParameter.setExplode(Boolean.valueOf(exploded));
                    }
                } else if (parameter.isAnnotationPresent(Header.class)) {
                    String headerName = parameter.getValue(Header.class, "name", String.class).orElse(parameter.getValue(Header.class, String.class).orElseGet(() -> NameUtils.hyphenate((String)parameterName)));
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.HEADER.toString());
                    newParameter.setName(headerName);
                } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                    String cookieName = parameter.getValue(CookieValue.class, String.class).orElse(parameterName);
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.COOKIE.toString());
                    newParameter.setName(cookieName);
                } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                    String queryVar = parameter.getValue(QueryValue.class, String.class).orElse(parameterName);
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.QUERY.toString());
                    newParameter.setName(queryVar);
                } else if (!permitsRequestBody && this.hasNoBindingAnnotationOrType(parameter)) {
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.QUERY.toString());
                    newParameter.setName(parameterName);
                }
                if (parameter.isAnnotationPresent(Parameter.class) && (paramAnn = (AnnotationValue)parameter.findAnnotation(Parameter.class).orElse(null)) != null) {
                    if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) continue;
                    Map<CharSequence, Object> paramValues = this.toValueMap(paramAnn.getValues(), context);
                    this.normalizeEnumValues(paramValues, Collections.singletonMap("in", ParameterIn.class));
                    if (parameter.isAnnotationPresent(Header.class)) {
                        paramValues.put("in", ParameterIn.HEADER.toString());
                    } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                        paramValues.put("in", ParameterIn.COOKIE.toString());
                    } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                        paramValues.put("in", ParameterIn.QUERY.toString());
                    }
                    this.processExplode((AnnotationValue<Parameter>)paramAnn, paramValues);
                    JsonNode jsonNode = this.jsonMapper.valueToTree(paramValues);
                    if (newParameter == null) {
                        try {
                            newParameter = this.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class);
                        }
                        catch (Exception e) {
                            context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                        }
                    } else {
                        try {
                            io.swagger.v3.oas.models.parameters.Parameter v = this.treeToValue(jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class);
                            if (v != null) {
                                BeanMap beanMap = BeanMap.of((Object)v);
                                BeanMap target = BeanMap.of((Object)newParameter);
                                for (CharSequence name : paramValues.keySet()) {
                                    Object o2 = beanMap.get((Object)name.toString());
                                    target.put((Object)name.toString(), o2);
                                }
                            } else {
                                BeanMap target = BeanMap.of((Object)newParameter);
                                for (CharSequence name : paramValues.keySet()) {
                                    Object o3 = paramValues.get(name.toString());
                                    try {
                                        target.put((Object)name.toString(), o3);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        catch (IOException e) {
                            context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                        }
                    }
                    if (newParameter != null) {
                        AnnotationValue schemaAnn;
                        Schema parameterSchema = newParameter.getSchema();
                        if (paramAnn.contains("schema") && parameterSchema != null && (schemaAnn = (AnnotationValue)paramAnn.get((CharSequence)"schema", AnnotationValue.class).orElse(null)) != null) {
                            this.bindSchemaAnnotationValue(context, (Element)parameter, parameterSchema, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
                        }
                    }
                }
                if (newParameter == null) continue;
                if (StringUtils.isEmpty((CharSequence)newParameter.getName())) {
                    newParameter.setName(parameterName);
                }
                if (newParameter.getRequired() == null) {
                    newParameter.setRequired(Boolean.valueOf(!parameter.isAnnotationPresent(Nullable.class)));
                }
                if (javadocDescription != null && StringUtils.isEmpty((CharSequence)newParameter.getDescription()) && (desc = javadocDescription.getParameters().get(parameterName)) != null) {
                    newParameter.setDescription(desc.toString());
                }
                swaggerParameters.add(newParameter);
                Schema schema = newParameter.getSchema();
                if (schema == null) {
                    schema = this.resolveSchema(openAPI, (Element)parameter, parameterType, context, consumesMediaType);
                }
                if (schema == null) continue;
                this.bindSchemaForElement(context, (Element)parameter, parameter.getType(), schema);
                newParameter.setSchema(schema);
            }
            if (HttpMethod.requiresRequestBody((HttpMethod)httpMethod) && swaggerOperation.getRequestBody() == null && !(bodyParameters = Arrays.stream(element.getParameters()).filter(p -> !pathVariables.containsKey(p.getName()) && !p.isAnnotationPresent(Bindable.class) && !p.isAnnotationPresent(JsonIgnore.class) && !p.isAnnotationPresent(Hidden.class) && !p.isAnnotationPresent(Header.class) && !p.isAnnotationPresent(QueryValue.class) && !p.getValue(Parameter.class, "in", ParameterIn.class).isPresent() && p.getValue(Parameter.class, "hidden", Boolean.class).orElse(false) == false && !this.isIgnoredParameterType(p.getType())).collect(Collectors.toList())).isEmpty()) {
                RequestBody requestBody = new RequestBody();
                Content content = new Content();
                consumesMediaTypes = consumesMediaTypes.isEmpty() ? OptionalValues.of(List.class, Collections.singletonMap("value", "application/json")) : consumesMediaTypes;
                consumesMediaTypes.forEach((key, mediaTypeList) -> {
                    for (Object mediaType : mediaTypeList) {
                        MediaType mt = new MediaType();
                        ObjectSchema schema = new ObjectSchema();
                        for (ParameterElement parameter : bodyParameters) {
                            CharSequence doc;
                            Schema propertySchema = this.resolveSchema(openAPI, (Element)parameter, parameter.getType(), context, mediaType.toString());
                            if (propertySchema == null) continue;
                            Optional description = parameter.getValue(Parameter.class, "description", String.class);
                            if (description.isPresent()) {
                                propertySchema.setDescription((String)description.get());
                            }
                            this.processSchemaProperty(context, (Element)parameter, parameter.getType(), (Schema)schema, propertySchema);
                            propertySchema.setNullable(Boolean.valueOf(parameter.isAnnotationPresent(Nullable.class)));
                            if (javadocDescription == null || !StringUtils.isEmpty((CharSequence)propertySchema.getDescription()) || (doc = javadocDescription.getParameters().get(parameter.getName())) == null) continue;
                            propertySchema.setDescription(doc.toString());
                        }
                        mt.setSchema((Schema)schema);
                        content.addMediaType(mediaType.toString(), mt);
                    }
                });
                requestBody.setContent(content);
                requestBody.setRequired(Boolean.valueOf(true));
                swaggerOperation.setRequestBody(requestBody);
            }
        });
    }

    private void processExplode(AnnotationValue<Parameter> paramAnn, Map<CharSequence, Object> paramValues) {
        Optional explode = paramAnn.enumValue("explode", Explode.class);
        if (explode.isPresent()) {
            Explode ex = (Explode)explode.get();
            block0 : switch (ex) {
                case TRUE: {
                    paramValues.put("explode", Boolean.TRUE);
                    break;
                }
                case FALSE: {
                    paramValues.put("explode", Boolean.FALSE);
                    break;
                }
                default: {
                    String in = (String)paramValues.get("in");
                    if (in == null || in.isEmpty()) {
                        in = "DEFAULT";
                    }
                    switch (ParameterIn.valueOf((String)in.toUpperCase(Locale.US))) {
                        case COOKIE: 
                        case QUERY: {
                            paramValues.put("explode", Boolean.TRUE);
                            break block0;
                        }
                    }
                    paramValues.put("explode", Boolean.FALSE);
                }
            }
        }
    }

    private boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.security.authentication.Authentication");
    }

    private boolean isResponseType(ClassElement returnType) {
        return returnType.isAssignable(HttpResponse.class) || returnType.isAssignable("org.springframework.http.HttpEntity");
    }

    private boolean isSingleResponseType(ClassElement returnType) {
        return returnType.isAssignable("io.reactivex.Single") && returnType.getFirstTypeArgument().isPresent() && this.isResponseType((ClassElement)returnType.getFirstTypeArgument().get());
    }

    private void setOperationOnPathItem(PathItem pathItem, Operation swaggerOperation, HttpMethod httpMethod) {
        switch (httpMethod) {
            case GET: {
                pathItem.get(swaggerOperation);
                break;
            }
            case POST: {
                pathItem.post(swaggerOperation);
                break;
            }
            case PUT: {
                pathItem.put(swaggerOperation);
                break;
            }
            case PATCH: {
                pathItem.patch(swaggerOperation);
                break;
            }
            case DELETE: {
                pathItem.delete(swaggerOperation);
                break;
            }
            case HEAD: {
                pathItem.head(swaggerOperation);
                break;
            }
            case OPTIONS: {
                pathItem.options(swaggerOperation);
                break;
            }
            case TRACE: {
                pathItem.trace(swaggerOperation);
                break;
            }
        }
    }

    private void readApiResponses(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List responseAnnotations = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        if (CollectionUtils.isNotEmpty((Collection)responseAnnotations)) {
            ApiResponses apiResponses = new ApiResponses();
            for (AnnotationValue r : responseAnnotations) {
                Optional<ApiResponse> newResponse = this.toValue(r.getValues(), context, ApiResponse.class);
                newResponse.ifPresent(apiResponse -> {
                    ApiResponse cfr_ignored_0 = (ApiResponse)apiResponses.put((Object)r.get((CharSequence)"responseCode", String.class).orElse("default"), apiResponse);
                });
            }
            swaggerOperation.setResponses(apiResponses);
        }
    }

    private void readSwaggerRequestBody(Element element, VisitorContext context, Operation swaggerOperation) {
        element.findAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class).flatMap(annotation -> this.toValue(annotation.getValues(), context, RequestBody.class)).ifPresent(arg_0 -> ((Operation)swaggerOperation).setRequestBody(arg_0));
    }

    private void readServers(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List<io.swagger.v3.oas.models.servers.Server> servers = this.processOpenApiAnnotation((Element)element, context, Server.class, io.swagger.v3.oas.models.servers.Server.class, Collections.emptyList());
        for (io.swagger.v3.oas.models.servers.Server server : servers) {
            swaggerOperation.addServersItem(server);
        }
    }

    private void readCallbacks(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List callbackAnnotations = element.getAnnotationValuesByType(Callback.class);
        if (CollectionUtils.isNotEmpty((Collection)callbackAnnotations)) {
            for (AnnotationValue callbackAnn : callbackAnnotations) {
                Optional n = callbackAnn.get((CharSequence)"name", String.class);
                n.ifPresent(callbackName -> {
                    Optional expr = callbackAnn.get((CharSequence)"callbackUrlExpression", String.class);
                    if (expr.isPresent()) {
                        String callbackUrl = (String)expr.get();
                        List operations = callbackAnn.getAnnotations("operation", io.swagger.v3.oas.annotations.Operation.class);
                        if (CollectionUtils.isEmpty((Collection)operations)) {
                            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
                            io.swagger.v3.oas.models.callbacks.Callback c = new io.swagger.v3.oas.models.callbacks.Callback();
                            c.addPathItem(callbackUrl, new PathItem());
                            callbacks.put((String)callbackName, c);
                        } else {
                            PathItem pathItem = new PathItem();
                            for (AnnotationValue operation : operations) {
                                Optional operationMethod = operation.get((CharSequence)"method", HttpMethod.class);
                                operationMethod.ifPresent(httpMethod -> this.toValue(operation.getValues(), context, Operation.class).ifPresent(op -> this.setOperationOnPathItem(pathItem, (Operation)op, (HttpMethod)httpMethod)));
                            }
                            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
                            io.swagger.v3.oas.models.callbacks.Callback c = new io.swagger.v3.oas.models.callbacks.Callback();
                            c.addPathItem(callbackUrl, pathItem);
                            callbacks.put((String)callbackName, c);
                        }
                    } else {
                        Components components = this.resolveComponents(this.resolveOpenAPI(context));
                        Map callbackComponents = components.getCallbacks();
                        if (callbackComponents != null && callbackComponents.containsKey(callbackName)) {
                            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
                            io.swagger.v3.oas.models.callbacks.Callback callbackRef = new io.swagger.v3.oas.models.callbacks.Callback();
                            callbackRef.set$ref("#/components/callbacks/" + callbackName);
                            callbacks.put((String)callbackName, callbackRef);
                        }
                    }
                });
            }
        }
    }

    private Map<String, io.swagger.v3.oas.models.callbacks.Callback> initCallbacks(Operation swaggerOperation) {
        LinkedHashMap callbacks = swaggerOperation.getCallbacks();
        if (callbacks == null) {
            callbacks = new LinkedHashMap();
            swaggerOperation.setCallbacks(callbacks);
        }
        return callbacks;
    }

    private void readTags(MethodElement element, Operation swaggerOperation, List<io.swagger.v3.oas.models.tags.Tag> classTags) {
        List tagAnnotations = element.getAnnotationValuesByType(Tag.class);
        if (CollectionUtils.isNotEmpty((Collection)tagAnnotations)) {
            for (AnnotationValue r : tagAnnotations) {
                r.get((CharSequence)"name", String.class).ifPresent(arg_0 -> ((Operation)swaggerOperation).addTagsItem(arg_0));
            }
        }
        if (!classTags.isEmpty()) {
            ArrayList<String> operationTags = swaggerOperation.getTags();
            if (operationTags == null) {
                operationTags = new ArrayList<String>(classTags.size());
                swaggerOperation.setTags(operationTags);
            }
            for (io.swagger.v3.oas.models.tags.Tag tag : classTags) {
                if (operationTags.contains(tag.getName())) continue;
                operationTags.add(tag.getName());
            }
        }
    }

    private List<io.swagger.v3.oas.models.tags.Tag> readTags(ClassElement element, VisitorContext context) {
        ArrayList<io.swagger.v3.oas.models.tags.Tag> tagList = new ArrayList<io.swagger.v3.oas.models.tags.Tag>();
        List tagAnnotations = element.getAnnotationValuesByType(Tag.class);
        if (CollectionUtils.isNotEmpty((Collection)tagAnnotations)) {
            for (AnnotationValue tag : tagAnnotations) {
                this.toValue(tag.getValues(), context, io.swagger.v3.oas.models.tags.Tag.class).ifPresent(tagList::add);
            }
        }
        return tagList;
    }

    private Content buildContent(Element definingElement, ClassElement type, String mediaType, OpenAPI openAPI, VisitorContext context) {
        Content content = new Content();
        MediaType mt = new MediaType();
        mt.setSchema(this.resolveSchema(openAPI, definingElement, type, context, mediaType));
        content.addMediaType(mediaType, mt);
        return content;
    }

    private Content buildContent(Element definingElement, ClassElement type, OptionalValues<List> mediaTypes, OpenAPI openAPI, VisitorContext context) {
        Content content = new Content();
        mediaTypes.forEach((key, mediaTypesList) -> {
            for (Object mediaType : mediaTypesList) {
                MediaType mt = new MediaType();
                mt.setSchema(this.resolveSchema(openAPI, definingElement, type, context, mediaType.toString()));
                content.addMediaType(mediaType.toString(), mt);
            }
        });
        return content;
    }

    PropertyPlaceholderResolver getPropertyPlaceholderResolver() {
        if (this.propertyPlaceholderResolver == null) {
            this.propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(new PropertyResolver(){

                public boolean containsProperty(@Nonnull String name) {
                    return false;
                }

                public boolean containsProperties(@Nonnull String name) {
                    return false;
                }

                @Nonnull
                public <T> Optional<T> getProperty(@Nonnull String name, @Nonnull ArgumentConversionContext<T> conversionContext) {
                    return Optional.empty();
                }
            }, (ConversionService)new DefaultConversionService());
        }
        return this.propertyPlaceholderResolver;
    }
}

