/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;

@Internal
public class JavaClassElementExt
extends JavaClassElement {
    private final JavaClassElement javaClassElement;
    private final TypeElement classElement;
    private final JavaVisitorContext visitorContext;
    private Map<String, Map<String, TypeMirror>> genericTypeInfo;

    public JavaClassElementExt(ClassElement ce, VisitorContext visitorContext) {
        this((JavaClassElement)ce, (JavaVisitorContext)visitorContext);
    }

    private JavaClassElementExt(JavaClassElement jce, JavaVisitorContext visitorContext) {
        super((TypeElement)jce.getNativeType(), jce.getAnnotationMetadata(), visitorContext);
        this.javaClassElement = jce;
        this.classElement = (TypeElement)jce.getNativeType();
        this.visitorContext = visitorContext;
        this.genericTypeInfo = jce.getGenericTypeInfo();
    }

    public List<PropertyElement> getFluentBeanProperties() {
        final ArrayList props = new ArrayList();
        final LinkedHashMap fields = new LinkedHashMap();
        final HashSet fieldNames = new HashSet();
        this.classElement.asType().accept(new PublicMethodVisitor<Object, Object>(this.visitorContext.getTypes()){

            protected boolean isAcceptable(Element element) {
                Set<Modifier> modifiers;
                if (element.getKind() == ElementKind.FIELD) {
                    fieldNames.add(element.getSimpleName().toString());
                    return true;
                }
                if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (modifiers = element.getModifiers()).contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.ABSTRACT)) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    String methodName = executableElement.getSimpleName().toString();
                    if (methodName.contains("$")) {
                        return false;
                    }
                    return executableElement.getParameters().isEmpty() || executableElement.getParameters().size() == 1;
                }
                return false;
            }

            private BeanPropertyData computeIfAbsent(String propertyName) {
                for (BeanPropertyData bpd : props) {
                    if (!propertyName.equals(bpd.propertyName)) continue;
                    return bpd;
                }
                BeanPropertyData bpd = new BeanPropertyData(propertyName);
                props.add(bpd);
                return bpd;
            }

            protected void accept(DeclaredType declaringType, Element element, Object o) {
                if (element instanceof VariableElement) {
                    fields.put(element.getSimpleName().toString(), (VariableElement)element);
                    return;
                }
                String methodName = element.getSimpleName().toString();
                if (!fieldNames.contains(methodName)) {
                    return;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
                if (executableElement.getParameters().isEmpty()) {
                    TypeMirror typeMirror;
                    ClassElement setterParameterType;
                    ClassElement getterReturnType;
                    String propertyName = methodName;
                    TypeMirror returnType = executableElement.getReturnType();
                    if (returnType instanceof TypeVariable) {
                        TypeVariable tv = (TypeVariable)returnType;
                        String tvn = tv.toString();
                        ClassElement clElement = (ClassElement)JavaClassElementExt.this.getTypeArguments().get(tvn);
                        getterReturnType = clElement != null ? clElement : JavaClassElementExt.this.mirrorToClassElement(returnType, JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
                    } else {
                        getterReturnType = JavaClassElementExt.this.mirrorToClassElement(returnType, JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
                    }
                    BeanPropertyData beanPropertyData = this.computeIfAbsent(propertyName);
                    this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                    beanPropertyData.type = getterReturnType;
                    beanPropertyData.getter = executableElement;
                    if (beanPropertyData.setter != null && !(setterParameterType = JavaClassElementExt.this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo)).getName().equals(getterReturnType.getName())) {
                        beanPropertyData.setter = null;
                    }
                } else if (executableElement.getParameters().size() == 1) {
                    String propertyName = methodName;
                    TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
                    ClassElement setterParameterType = JavaClassElementExt.this.mirrorToClassElement(typeMirror, JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
                    BeanPropertyData beanPropertyData = this.computeIfAbsent(propertyName);
                    this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                    ClassElement propertyType = beanPropertyData.type;
                    if (propertyType != null) {
                        if (propertyType.getName().equals(setterParameterType.getName())) {
                            beanPropertyData.setter = executableElement;
                        }
                    } else {
                        beanPropertyData.setter = executableElement;
                    }
                }
            }

            private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
                if (beanPropertyData.declaringType == null && !JavaClassElementExt.this.classElement.equals(declaringTypeElement)) {
                    beanPropertyData.declaringType = JavaClassElementExt.this.mirrorToClassElement(declaringTypeElement.asType(), JavaClassElementExt.this.visitorContext, JavaClassElementExt.this.genericTypeInfo);
                }
            }
        }, null);
        if (!props.isEmpty()) {
            ArrayList<2> propertyElements = new ArrayList<2>();
            for (final BeanPropertyData value : props) {
                String propertyName = value.propertyName;
                if (value.getter == null) continue;
                VariableElement fieldElement = (VariableElement)fields.get(propertyName);
                final AnnotationMetadata annotationMetadata = fieldElement != null ? this.visitorContext.getAnnotationUtils().getAnnotationMetadata((Element)fieldElement, (Element)value.getter) : this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.getter);
                JavaPropertyElement propertyElement = new JavaPropertyElement((ClassElement)(value.declaringType == null ? this.javaClassElement : value.declaringType), value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

                    public Optional<String> getDocumentation() {
                        Elements elements = JavaClassElementExt.this.visitorContext.getElements();
                        String docComment = elements.getDocComment(value.getter);
                        return Optional.ofNullable(docComment);
                    }

                    public Optional<MethodElement> getWriteMethod() {
                        if (value.setter != null) {
                            return Optional.of(new JavaMethodElement(JavaClassElementExt.this.javaClassElement, value.setter, JavaClassElementExt.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.setter), JavaClassElementExt.this.visitorContext));
                        }
                        return Optional.empty();
                    }

                    public Optional<MethodElement> getReadMethod() {
                        return Optional.of(new JavaMethodElement(JavaClassElementExt.this.javaClassElement, value.getter, annotationMetadata, JavaClassElementExt.this.visitorContext));
                    }
                };
                propertyElements.add(propertyElement);
            }
            return Collections.unmodifiableList(propertyElements);
        }
        return Collections.emptyList();
    }

    private static class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        public BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

