/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.OpenApiViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.Renderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SwaggerUIConfig
extends AbstractViewConfig
implements Renderer {
    private static final Map<String, Object> DEFAULT_OPTIONS = new HashMap<String, Object>(4);
    private static final Map<String, Function<String, Object>> VALID_OPTIONS = new HashMap<String, Function<String, Object>>(16);
    RapiPDFConfig rapiPDFConfig;
    private Theme theme = Theme.DEFAULT;

    private SwaggerUIConfig() {
        super("swagger-ui.");
    }

    private String toOptions() {
        return this.options.entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(",\n"));
    }

    static SwaggerUIConfig fromProperties(Map<String, String> properties) {
        SwaggerUIConfig cfg = new SwaggerUIConfig();
        cfg.theme = Theme.valueOf(properties.getOrDefault("swagger-ui.theme", cfg.theme.name()).toUpperCase(Locale.US));
        return AbstractViewConfig.fromProperties(cfg, DEFAULT_OPTIONS, properties);
    }

    @Override
    public String render(String template) {
        template = this.rapiPDFConfig.render(template, OpenApiViewConfig.RendererType.SWAGGER_UI);
        template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.version", this.version, "@");
        template = OpenApiViewConfig.replacePlaceHolder(template, "swagger-ui.attributes", this.toOptions(), "");
        template = this.theme == null || Theme.DEFAULT.equals((Object)this.theme) ? template.replace("{{swagger-ui.theme}}", "") : template.replace("{{swagger-ui.theme}}", "<link rel='stylesheet' type='text/css' href='https://unpkg.com/swagger-ui-themes@3.0.0/themes/3.x/" + this.theme.getCss() + ".css' />");
        return template;
    }

    @Override
    protected Function<String, Object> getConverter(String key) {
        return VALID_OPTIONS.get(key);
    }

    static {
        VALID_OPTIONS.put("layout", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("deepLinking", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("displayOperationId", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("defaultModelsExpandDepth", AbstractViewConfig::asString);
        VALID_OPTIONS.put("defaultModelRendering", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("displayRequestDuration", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("docExpansion", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("filter", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("maxDisplayedTags", AbstractViewConfig::asString);
        VALID_OPTIONS.put("showExtensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("showCommonExtensions", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("oauth2RedirectUrl", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("showMutatedRequest", AbstractViewConfig::asBoolean);
        VALID_OPTIONS.put("supportedSubmitMethods", AbstractViewConfig::asString);
        VALID_OPTIONS.put("validatorUrl", AbstractViewConfig::asQuotedString);
        VALID_OPTIONS.put("withCredentials", AbstractViewConfig::asBoolean);
        DEFAULT_OPTIONS.put("layout", "\"StandaloneLayout\"");
        DEFAULT_OPTIONS.put("deepLinking", Boolean.TRUE);
        DEFAULT_OPTIONS.put("validatorUrl", null);
    }

    static enum Theme {
        DEFAULT(null),
        MATERIAL("theme-material"),
        FEELING_BLUE("theme-feeling-blue"),
        FLATTOP("theme-flattop"),
        MONOKAI("theme-monokai"),
        MUTED("theme-muted"),
        NEWSPAPER("theme-newspaper"),
        OUTLINE("theme-outline");

        private String css;

        private Theme(String css) {
            this.css = css;
        }

        public String getCss() {
            return this.css;
        }
    }
}

